/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.expressions;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.expressions.DSCompilerKt;
import space.kscience.kmath.operations.Algebra;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u001c\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0010\b\u0001\u0010\u0002 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004BK\b\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010)\u001a\u00020\u00072\n\u0010*\u001a\u00020\u0011\"\u00020\u0007J\u000e\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0007R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR'\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u00118@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0015\u001a\u0004\b\u001d\u0010\u001eR'\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b!\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0011\u0010$\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR!\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0015\u001a\u0004\b'\u0010\u0018\u00a8\u0006-"}, d2={"Lspace/kscience/kmath/expressions/DSCompiler;", "T", "A", "Lspace/kscience/kmath/operations/Algebra;", "", "algebra", "freeParameters", "", "order", "valueCompiler", "derivativeCompiler", "(Lspace/kscience/kmath/operations/Algebra;IILspace/kscience/kmath/expressions/DSCompiler;Lspace/kscience/kmath/expressions/DSCompiler;)V", "getAlgebra", "()Lspace/kscience/kmath/operations/Algebra;", "Lspace/kscience/kmath/operations/Algebra;", "compositionIndirection", "", "", "getCompositionIndirection$kmath_core", "()[[[I", "compositionIndirection$delegate", "Lkotlin/Lazy;", "derivativesIndirection", "getDerivativesIndirection$kmath_core", "()[[I", "derivativesIndirection$delegate", "getFreeParameters", "()I", "lowerIndirection", "getLowerIndirection$kmath_core", "()[I", "lowerIndirection$delegate", "multIndirection", "getMultIndirection$kmath_core", "multIndirection$delegate", "getOrder", "size", "getSize", "sizes", "getSizes", "sizes$delegate", "getPartialDerivativeIndex", "orders", "getPartialDerivativeOrders", "index", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nDSCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSCompiler.kt\nspace/kscience/kmath/expressions/DSCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1486:1\n1#2:1487\n*E\n"})
public final class DSCompiler<T, A extends Algebra<T>> {
    @NotNull
    private final A algebra;
    private final int freeParameters;
    private final int order;
    @NotNull
    private final Lazy sizes$delegate;
    @NotNull
    private final Lazy derivativesIndirection$delegate;
    @NotNull
    private final Lazy lowerIndirection$delegate;
    @NotNull
    private final Lazy multIndirection$delegate;
    @NotNull
    private final Lazy compositionIndirection$delegate;

    public DSCompiler(@NotNull A algebra, int freeParameters, int order, @Nullable DSCompiler<T, ? extends A> valueCompiler, @Nullable DSCompiler<T, ? extends A> derivativeCompiler) {
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        this.algebra = algebra;
        this.freeParameters = freeParameters;
        this.order = order;
        this.sizes$delegate = LazyKt.lazy(() -> DSCompiler.sizes_delegate$lambda$0(this, valueCompiler));
        this.derivativesIndirection$delegate = LazyKt.lazy(() -> DSCompiler.derivativesIndirection_delegate$lambda$1(this, valueCompiler, derivativeCompiler));
        this.lowerIndirection$delegate = LazyKt.lazy(() -> DSCompiler.lowerIndirection_delegate$lambda$2(this, valueCompiler, derivativeCompiler));
        this.multIndirection$delegate = LazyKt.lazy(() -> DSCompiler.multIndirection_delegate$lambda$3(this, valueCompiler, derivativeCompiler));
        this.compositionIndirection$delegate = LazyKt.lazy(() -> DSCompiler.compositionIndirection_delegate$lambda$4(this, valueCompiler, derivativeCompiler));
    }

    @NotNull
    public final A getAlgebra() {
        return this.algebra;
    }

    public final int getFreeParameters() {
        return this.freeParameters;
    }

    public final int getOrder() {
        return this.order;
    }

    @NotNull
    public final int[][] getSizes() {
        Lazy lazy = this.sizes$delegate;
        return (int[][])lazy.getValue();
    }

    @NotNull
    public final int[][] getDerivativesIndirection$kmath_core() {
        Lazy lazy = this.derivativesIndirection$delegate;
        return (int[][])lazy.getValue();
    }

    @NotNull
    public final int[] getLowerIndirection$kmath_core() {
        Lazy lazy = this.lowerIndirection$delegate;
        return (int[])lazy.getValue();
    }

    @NotNull
    public final int[][][] getMultIndirection$kmath_core() {
        Lazy lazy = this.multIndirection$delegate;
        return (int[][][])lazy.getValue();
    }

    @NotNull
    public final int[][][] getCompositionIndirection$kmath_core() {
        Lazy lazy = this.compositionIndirection$delegate;
        return (int[][][])lazy.getValue();
    }

    public final int getSize() {
        return this.getSizes()[this.freeParameters][this.order];
    }

    public final int getPartialDerivativeIndex(int ... orders) {
        Intrinsics.checkNotNullParameter((Object)orders, (String)"orders");
        if (!(orders.length == this.freeParameters)) {
            boolean bl = false;
            String string = "dimension mismatch: " + orders.length + " and " + this.freeParameters;
            throw new IllegalArgumentException(string.toString());
        }
        return DSCompilerKt.access$getPartialDerivativeIndex(this.freeParameters, this.order, this.getSizes(), Arrays.copyOf(orders, orders.length));
    }

    @NotNull
    public final int[] getPartialDerivativeOrders(int index) {
        return this.getDerivativesIndirection$kmath_core()[index];
    }

    private static final int[][] sizes_delegate$lambda$0(DSCompiler this$0, DSCompiler $valueCompiler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DSCompilerKt.access$compileSizes(this$0.freeParameters, this$0.order, $valueCompiler);
    }

    private static final int[][] derivativesIndirection_delegate$lambda$1(DSCompiler this$0, DSCompiler $valueCompiler, DSCompiler $derivativeCompiler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DSCompilerKt.access$compileDerivativesIndirection(this$0.freeParameters, this$0.order, $valueCompiler, $derivativeCompiler);
    }

    private static final int[] lowerIndirection_delegate$lambda$2(DSCompiler this$0, DSCompiler $valueCompiler, DSCompiler $derivativeCompiler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DSCompilerKt.access$compileLowerIndirection(this$0.freeParameters, this$0.order, $valueCompiler, $derivativeCompiler);
    }

    private static final int[][][] multIndirection_delegate$lambda$3(DSCompiler this$0, DSCompiler $valueCompiler, DSCompiler $derivativeCompiler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DSCompilerKt.access$compileMultiplicationIndirection(this$0.freeParameters, this$0.order, $valueCompiler, $derivativeCompiler, this$0.getLowerIndirection$kmath_core());
    }

    private static final int[][][] compositionIndirection_delegate$lambda$4(DSCompiler this$0, DSCompiler $valueCompiler, DSCompiler $derivativeCompiler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return DSCompilerKt.access$compileCompositionIndirection(this$0.freeParameters, this$0.order, $valueCompiler, $derivativeCompiler, this$0.getSizes(), this$0.getDerivativesIndirection$kmath_core());
    }
}

