/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.expressions;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.expressions.DifferentiableExpression;
import space.kscience.kmath.expressions.Expression;
import space.kscience.kmath.expressions.ExpressionWithDefaultKt;
import space.kscience.kmath.expressions.Symbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\"\u0010\f\u001a\u00028\u00002\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lspace/kscience/kmath/expressions/DiffExpressionWithDefault;", "T", "Lspace/kscience/kmath/expressions/DifferentiableExpression;", "origin", "defaultArgs", "", "Lspace/kscience/kmath/expressions/Symbol;", "(Lspace/kscience/kmath/expressions/DifferentiableExpression;Ljava/util/Map;)V", "derivativeOrNull", "Lspace/kscience/kmath/expressions/Expression;", "symbols", "", "invoke", "arguments", "(Ljava/util/Map;)Ljava/lang/Object;", "kmath-core"})
public final class DiffExpressionWithDefault<T>
implements DifferentiableExpression<T> {
    @NotNull
    private final DifferentiableExpression<T> origin;
    @NotNull
    private final Map<Symbol, T> defaultArgs;

    public DiffExpressionWithDefault(@NotNull DifferentiableExpression<T> origin, @NotNull Map<Symbol, ? extends T> defaultArgs) {
        Intrinsics.checkNotNullParameter(origin, (String)"origin");
        Intrinsics.checkNotNullParameter(defaultArgs, (String)"defaultArgs");
        this.origin = origin;
        this.defaultArgs = defaultArgs;
    }

    @Override
    public T invoke(@NotNull Map<Symbol, ? extends T> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return this.origin.invoke(MapsKt.plus(this.defaultArgs, arguments));
    }

    @Override
    @Nullable
    public Expression<T> derivativeOrNull(@NotNull List<? extends Symbol> symbols) {
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        Expression<T> expression = this.origin.derivativeOrNull(symbols);
        return expression != null ? ExpressionWithDefaultKt.withDefaultArgs(expression, this.defaultArgs) : null;
    }
}

