/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.expressions;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.expressions.Expression;
import space.kscience.kmath.expressions.MST;
import space.kscience.kmath.expressions.Symbol;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.AlgebraKt;
import space.kscience.kmath.operations.NumericAlgebra;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\u001aO\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00042*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00010\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\t\u001a7\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001a(\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\r\"\b\b\u0000\u0010\u0001*\u00020\u000e*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\u00a8\u0006\u000f"}, d2={"interpret", "T", "Lspace/kscience/kmath/expressions/MST;", "algebra", "Lspace/kscience/kmath/operations/Algebra;", "arguments", "", "Lkotlin/Pair;", "Lspace/kscience/kmath/expressions/Symbol;", "(Lspace/kscience/kmath/expressions/MST;Lspace/kscience/kmath/operations/Algebra;[Lkotlin/Pair;)Ljava/lang/Object;", "", "(Lspace/kscience/kmath/expressions/MST;Lspace/kscience/kmath/operations/Algebra;Ljava/util/Map;)Ljava/lang/Object;", "toExpression", "Lspace/kscience/kmath/expressions/Expression;", "", "kmath-core"})
public final class MSTKt {
    public static final <T> T interpret(@NotNull MST $this$interpret, @NotNull Algebra<T> algebra, @NotNull Map<Symbol, ? extends T> arguments) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        MST mST = $this$interpret;
        if (mST instanceof MST.Numeric) {
            object = ((NumericAlgebra)algebra).number(((MST.Numeric)$this$interpret).getValue());
            if (object == null) {
                throw new IllegalStateException(("Numeric nodes are not supported by " + algebra).toString());
            }
        } else if (mST instanceof Symbol) {
            object = AlgebraKt.bindSymbolOrNull(algebra, (Symbol)$this$interpret);
            if (object == null) {
                object = MapsKt.getValue(arguments, (Object)$this$interpret);
            }
        } else if (mST instanceof MST.Unary) {
            object = algebra instanceof NumericAlgebra && ((MST.Unary)$this$interpret).getValue() instanceof MST.Numeric ? algebra.unaryOperation(((MST.Unary)$this$interpret).getOperation(), ((NumericAlgebra)algebra).number(((MST.Numeric)((MST.Unary)$this$interpret).getValue()).getValue())) : algebra.unaryOperationFunction(((MST.Unary)$this$interpret).getOperation()).invoke(MSTKt.interpret(((MST.Unary)$this$interpret).getValue(), algebra, arguments));
        } else if (mST instanceof MST.Binary) {
            object = algebra instanceof NumericAlgebra && ((MST.Binary)$this$interpret).getLeft() instanceof MST.Numeric && ((MST.Binary)$this$interpret).getRight() instanceof MST.Numeric ? algebra.binaryOperation(((MST.Binary)$this$interpret).getOperation(), ((NumericAlgebra)algebra).number(((MST.Numeric)((MST.Binary)$this$interpret).getLeft()).getValue()), ((NumericAlgebra)algebra).number(((MST.Numeric)((MST.Binary)$this$interpret).getRight()).getValue())) : (algebra instanceof NumericAlgebra && ((MST.Binary)$this$interpret).getLeft() instanceof MST.Numeric ? ((NumericAlgebra)algebra).leftSideNumberOperation(((MST.Binary)$this$interpret).getOperation(), ((MST.Numeric)((MST.Binary)$this$interpret).getLeft()).getValue(), MSTKt.interpret(((MST.Binary)$this$interpret).getRight(), algebra, arguments)) : (algebra instanceof NumericAlgebra && ((MST.Binary)$this$interpret).getRight() instanceof MST.Numeric ? ((NumericAlgebra)algebra).rightSideNumberOperation(((MST.Binary)$this$interpret).getOperation(), MSTKt.interpret(((MST.Binary)$this$interpret).getLeft(), algebra, arguments), ((MST.Numeric)((MST.Binary)$this$interpret).getRight()).getValue()) : algebra.binaryOperation(((MST.Binary)$this$interpret).getOperation(), MSTKt.interpret(((MST.Binary)$this$interpret).getLeft(), algebra, arguments), MSTKt.interpret(((MST.Binary)$this$interpret).getRight(), algebra, arguments))));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static final <T> T interpret(@NotNull MST $this$interpret, @NotNull Algebra<T> algebra, Pair<? extends Symbol, ? extends T> ... arguments) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        switch (arguments.length) {
            case 0: {
                map = MapsKt.emptyMap();
                break;
            }
            case 1: {
                map = MapsKt.mapOf(arguments[0]);
                break;
            }
            default: {
                map = MapsKt.hashMapOf(Arrays.copyOf(arguments, arguments.length));
            }
        }
        return MSTKt.interpret($this$interpret, algebra, map);
    }

    @NotNull
    public static final <T> Expression<T> toExpression(@NotNull MST $this$toExpression, @NotNull Algebra<T> algebra) {
        Intrinsics.checkNotNullParameter((Object)$this$toExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter(algebra, (String)"algebra");
        return arg_0 -> MSTKt.toExpression$lambda$0($this$toExpression, algebra, arg_0);
    }

    private static final Object toExpression$lambda$0(MST $this_toExpression, Algebra $algebra, Map arguments) {
        Intrinsics.checkNotNullParameter((Object)$this_toExpression, (String)"$this_toExpression");
        Intrinsics.checkNotNullParameter((Object)$algebra, (String)"$algebra");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return MSTKt.interpret($this_toExpression, $algebra, arguments);
    }
}

