/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.linear;

import java.util.ArrayList;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.linear.LinearSolver;
import space.kscience.kmath.linear.LinearSpace;
import space.kscience.kmath.linear.LupDecomposition;
import space.kscience.kmath.linear.LupDecompositionKt;
import space.kscience.kmath.linear.MatrixWrapperKt;
import space.kscience.kmath.nd.Structure2D;
import space.kscience.kmath.operations.Algebra;
import space.kscience.kmath.operations.AlgebraExtensionsKt;
import space.kscience.kmath.operations.DoubleField;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.operations.Ring;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferAccessor2D;
import space.kscience.kmath.structures.DoubleBuffer;
import space.kscience.kmath.structures.FloatBuffer;
import space.kscience.kmath.structures.IntBuffer;
import space.kscience.kmath.structures.LongBuffer;
import space.kscience.kmath.structures.MutableBuffer;
import space.kscience.kmath.structures.MutableBufferFactory;
import space.kscience.kmath.structures.MutableListBuffer;
import space.kscience.kmath.structures.ShortBuffer;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\u001a;\u0010\u0000\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u0006\u0010\u0005\u001a\u0002H\u0001H\u0001\u00a2\u0006\u0002\u0010\u0006\u001ah\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\"\u0010\b\u0000\u0010\u0001\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\t0\u00032\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00010\u000bj\b\u0012\u0004\u0012\u0002H\u0001`\f2\u0014\b\b\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u000f0\u000eH\u0086\b\u00f8\u0001\u0000\u001al\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\b\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\t0\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00010\u000bj\b\u0012\u0004\u0012\u0002H\u0001`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u001a>\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00120\b*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00032\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u000bj\b\u0012\u0004\u0012\u00020\u0012`\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u001a^\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0016\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00010\t*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00170\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u001a&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u001aR\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u0002H\u00010\u000bj\b\u0012\u0004\u0012\u0002H\u0001`\f\"\b\b\u0000\u0010\u0001*\u00020\u001b*\b\u0012\u0004\u0012\u0002H\u00010\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00010\u000bj\b\u0012\u0004\u0012\u0002H\u0001`\fH\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"abs", "T", "", "Lspace/kscience/kmath/linear/LinearSpace;", "Lspace/kscience/kmath/operations/Ring;", "value", "(Lspace/kscience/kmath/linear/LinearSpace;Ljava/lang/Comparable;)Ljava/lang/Comparable;", "lup", "Lspace/kscience/kmath/linear/LupDecomposition;", "Lspace/kscience/kmath/operations/Field;", "matrix", "Lspace/kscience/kmath/nd/Structure2D;", "Lspace/kscience/kmath/linear/Matrix;", "checkSingular", "Lkotlin/Function1;", "", "factory", "Lspace/kscience/kmath/structures/MutableBufferFactory;", "", "Lspace/kscience/kmath/operations/DoubleField;", "singularityThreshold", "lupSolver", "Lspace/kscience/kmath/linear/LinearSolver;", "F", "bufferFactory", "singularityCheck", "solve", "", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nLupDecomposition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LupDecomposition.kt\nspace/kscience/kmath/linear/LupDecompositionKt\n+ 2 Algebra.kt\nspace/kscience/kmath/operations/AlgebraKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BufferAccessor2D.kt\nspace/kscience/kmath/structures/BufferAccessor2D\n*L\n1#1,231:1\n123#2:232\n123#2:234\n123#2:235\n1#3:233\n25#4:236\n*S KotlinDebug\n*F\n+ 1 LupDecomposition.kt\nspace/kscience/kmath/linear/LupDecompositionKt\n*L\n70#1:232\n86#1:234\n171#1:235\n173#1:236\n*E\n"})
public final class LupDecompositionKt {
    @PublishedApi
    @NotNull
    public static final <T extends Comparable<? super T>> T abs(@NotNull LinearSpace<T, ? extends Ring<T>> $this$abs, @NotNull T value) {
        Object object;
        Intrinsics.checkNotNullParameter($this$abs, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (value.compareTo($this$abs.getElementAlgebra().getZero()) > 0) {
            object = value;
        } else {
            Algebra $this$invoke$iv = $this$abs.getElementAlgebra();
            boolean $i$f$invoke = false;
            Ring $this$abs_u24lambda_u240 = (Ring)$this$invoke$iv;
            boolean bl = false;
            object = $this$abs_u24lambda_u240.unaryMinus(value);
        }
        return (T)object;
    }

    @NotNull
    public static final <T extends Comparable<? super T>> LupDecomposition<T> lup(@NotNull LinearSpace<T, ? extends Field<T>> $this$lup, @NotNull MutableBufferFactory<T> factory, @NotNull Structure2D<? extends T> matrix, @NotNull Function1<? super T, Boolean> checkSingular) {
        Intrinsics.checkNotNullParameter($this$lup, (String)"<this>");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter(matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter(checkSingular, (String)"checkSingular");
        if (!(matrix.getRowNum() == matrix.getColNum())) {
            boolean $i$a$-require-LupDecompositionKt$lup$22 = false;
            String $i$a$-require-LupDecompositionKt$lup$22 = "LU decomposition supports only square matrices";
            throw new IllegalArgumentException($i$a$-require-LupDecompositionKt$lup$22.toString());
        }
        int m = matrix.getColNum();
        int[] pivot = new int[matrix.getRowNum()];
        BufferAccessor2D<Object> $this$lup_u24lambda_u244 = new BufferAccessor2D<Object>(matrix.getRowNum(), matrix.getColNum(), factory);
        boolean bl = false;
        Algebra $this$invoke$iv = $this$lup.getElementAlgebra();
        boolean $i$f$invoke = false;
        Field $this$lup_u24lambda_u244_u24lambda_u243 = (Field)$this$invoke$iv;
        boolean bl2 = false;
        MutableBuffer<? extends T> lu = $this$lup_u24lambda_u244.create(matrix);
        for (int row2 = 0; row2 < m; ++row2) {
            pivot[row2] = row2;
        }
        boolean even = true;
        for (int row3 = 0; row3 < m; ++row3) {
            pivot[row3] = row3;
        }
        for (int col = 0; col < m; ++col) {
            for (int row4 = 0; row4 < col; ++row4) {
                BufferAccessor2D.Row luRow = $this$lup_u24lambda_u244.row(lu, row4);
                Comparable sum = (Comparable)luRow.get(col);
                for (int i = 0; i < row4; ++i) {
                    sum = $this$lup_u24lambda_u244_u24lambda_u243.minus(sum, $this$lup_u24lambda_u244_u24lambda_u243.times(luRow.get(i), $this$lup_u24lambda_u244.get((Buffer)lu, i, col)));
                }
                luRow.set(col, sum);
            }
            int max = col;
            Comparable largest = (Comparable)$this$lup_u24lambda_u244_u24lambda_u243.unaryMinus($this$lup_u24lambda_u244_u24lambda_u243.getOne());
            for (int row5 = col; row5 < m; ++row5) {
                BufferAccessor2D.Row luRow = $this$lup_u24lambda_u244.row(lu, row5);
                Comparable sum = (Comparable)luRow.get(col);
                for (int i = 0; i < col; ++i) {
                    sum = $this$lup_u24lambda_u244_u24lambda_u243.minus(sum, $this$lup_u24lambda_u244_u24lambda_u243.times(luRow.get(i), $this$lup_u24lambda_u244.get((Buffer)lu, i, col)));
                }
                luRow.set(col, sum);
                if (AlgebraExtensionsKt.abs($this$lup_u24lambda_u244_u24lambda_u243, sum).compareTo(largest) <= 0) continue;
                largest = AlgebraExtensionsKt.abs($this$lup_u24lambda_u244_u24lambda_u243, sum);
                max = row5;
            }
            if (!((Boolean)checkSingular.invoke((Object)AlgebraExtensionsKt.abs($this$lup_u24lambda_u244_u24lambda_u243, (Comparable)$this$lup_u24lambda_u244.get((Buffer)lu, max, col))) == false)) {
                boolean $i$a$-check-LupDecompositionKt$lup$2$1$22 = false;
                String $i$a$-check-LupDecompositionKt$lup$2$1$22 = "The matrix is singular";
                throw new IllegalStateException($i$a$-check-LupDecompositionKt$lup$2$1$22.toString());
            }
            if (max != col) {
                BufferAccessor2D.Row luMax = $this$lup_u24lambda_u244.row(lu, max);
                BufferAccessor2D.Row luCol = $this$lup_u24lambda_u244.row(lu, col);
                for (int i = 0; i < m; ++i) {
                    Comparable tmp = (Comparable)luMax.get(i);
                    luMax.set(i, luCol.get(i));
                    luCol.set(i, tmp);
                }
                int temp = pivot[max];
                pivot[max] = pivot[col];
                pivot[col] = temp;
                even = !even;
            }
            Comparable luDiag = (Comparable)$this$lup_u24lambda_u244.get((Buffer)lu, col, col);
            int row6 = col + 1;
            while (row6 < m) {
                int n = row6++;
                int n2 = col;
                $this$lup_u24lambda_u244.set(lu, n, n2, $this$lup_u24lambda_u244_u24lambda_u243.div($this$lup_u24lambda_u244.get((Buffer)lu, n, n2), luDiag));
            }
        }
        return new LupDecomposition<T>($this$lup, $this$lup.getElementAlgebra(), $this$lup_u24lambda_u244.collect(lu), pivot, even);
    }

    public static final /* synthetic */ <T extends Comparable<? super T>> LupDecomposition<T> lup(LinearSpace<T, ? extends Field<T>> $this$lup, Structure2D<? extends T> matrix, Function1<? super T, Boolean> checkSingular) {
        Intrinsics.checkNotNullParameter($this$lup, (String)"<this>");
        Intrinsics.checkNotNullParameter(matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter(checkSingular, (String)"checkSingular");
        boolean $i$f$lup = false;
        MutableBuffer.Companion companion = MutableBuffer.Companion;
        Intrinsics.needClassReification();
        return LupDecompositionKt.lup($this$lup, new MutableBufferFactory(companion){
            final /* synthetic */ MutableBuffer.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MutableBuffer<T> invoke(int p0, @NotNull Function1<? super Integer, ? extends T> p1) {
                MutableBuffer mutableBuffer;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                MutableBuffer.Companion this_$iv = this.$tmp0;
                boolean $i$f$auto = false;
                MutableBuffer.Companion companion = this_$iv;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Object.class);
                boolean $i$f$auto2 = false;
                KClass kClass = type$iv$iv;
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean bl = false;
                    boolean $i$f$DoubleBuffer = false;
                    int n = 0;
                    double[] dArray = new double[p0];
                    while (n < p0) {
                        double d;
                        void it$iv$iv;
                        int n2;
                        int n3 = n2 = n++;
                        int n4 = n2;
                        double[] dArray2 = dArray;
                        boolean bl2 = false;
                        Object object = p1.invoke((Object)((int)it$iv$iv));
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                        dArray2[n4] = d = ((Double)object).doubleValue();
                    }
                    mutableBuffer = DoubleBuffer.box-impl(DoubleBuffer.constructor-impl(dArray));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean bl = false;
                    boolean $i$f$ShortBuffer = false;
                    int n = 0;
                    short[] sArray = new short[p0];
                    while (n < p0) {
                        short s;
                        int n5;
                        int it$iv$iv = n5 = n++;
                        int n6 = n5;
                        short[] sArray2 = sArray;
                        boolean bl3 = false;
                        Object object = p1.invoke((Object)it$iv$iv);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                        sArray2[n6] = s = ((Short)object).shortValue();
                    }
                    mutableBuffer = ShortBuffer.box-impl(ShortBuffer.constructor-impl(sArray));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean bl = false;
                    boolean $i$f$IntBuffer = false;
                    int n = 0;
                    int[] nArray = new int[p0];
                    while (n < p0) {
                        int n7;
                        int n8;
                        int it$iv$iv = n8 = n++;
                        int n9 = n8;
                        int[] nArray2 = nArray;
                        boolean bl4 = false;
                        Object object = p1.invoke((Object)it$iv$iv);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        nArray2[n9] = n7 = ((Integer)object).intValue();
                    }
                    mutableBuffer = IntBuffer.box-impl(IntBuffer.constructor-impl(nArray));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean bl = false;
                    boolean $i$f$FloatBuffer = false;
                    int n = 0;
                    float[] fArray = new float[p0];
                    while (n < p0) {
                        float f;
                        int n10;
                        int it$iv$iv = n10 = n++;
                        int n11 = n10;
                        float[] fArray2 = fArray;
                        boolean bl5 = false;
                        Object object = p1.invoke((Object)it$iv$iv);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                        fArray2[n11] = f = ((Float)object).floatValue();
                    }
                    mutableBuffer = FloatBuffer.box-impl(FloatBuffer.constructor-impl(fArray));
                } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean bl = false;
                    boolean $i$f$LongBuffer = false;
                    int n = 0;
                    long[] lArray = new long[p0];
                    while (n < p0) {
                        long l;
                        int n12;
                        int it$iv$iv = n12 = n++;
                        int n13 = n12;
                        long[] lArray2 = lArray;
                        boolean bl6 = false;
                        Object object = p1.invoke((Object)it$iv$iv);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                        lArray2[n13] = l = ((Long)object).longValue();
                    }
                    mutableBuffer = LongBuffer.box-impl(LongBuffer.constructor-impl(lArray));
                } else {
                    void this_$iv$iv$iv = this_$iv$iv;
                    boolean $i$f$boxing = false;
                    ArrayList<Object> arrayList = new ArrayList<Object>(p0);
                    int n = 0;
                    while (n < p0) {
                        int n14 = n++;
                        arrayList.add(p1.invoke((Object)n14));
                    }
                    mutableBuffer = MutableListBuffer.box-impl(MutableListBuffer.constructor-impl((List)arrayList));
                }
                return mutableBuffer;
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(2, (Object)this.$tmp0, MutableBuffer.Companion.class, "auto", "auto(ILkotlin/jvm/functions/Function1;)Lspace/kscience/kmath/structures/MutableBuffer;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof MutableBufferFactory ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }, matrix, checkSingular);
    }

    @NotNull
    public static final LupDecomposition<Double> lup(@NotNull LinearSpace<Double, DoubleField> $this$lup, @NotNull Structure2D<Double> matrix, double singularityThreshold) {
        Intrinsics.checkNotNullParameter($this$lup, (String)"<this>");
        Intrinsics.checkNotNullParameter(matrix, (String)"matrix");
        return LupDecompositionKt.lup($this$lup, lup.4.INSTANCE, matrix, arg_0 -> LupDecompositionKt.lup$lambda$5(singularityThreshold, arg_0));
    }

    public static /* synthetic */ LupDecomposition lup$default(LinearSpace linearSpace, Structure2D structure2D, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0E-11;
        }
        return LupDecompositionKt.lup(linearSpace, structure2D, d);
    }

    @NotNull
    public static final <T> Structure2D<T> solve(@NotNull LupDecomposition<T> $this$solve, @NotNull MutableBufferFactory<T> factory, @NotNull Structure2D<? extends T> matrix) {
        int n;
        int i;
        int col;
        int col22;
        Intrinsics.checkNotNullParameter($this$solve, (String)"<this>");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter(matrix, (String)"matrix");
        if (!(matrix.getRowNum() == $this$solve.getPivot().length)) {
            boolean $i$a$-require-LupDecompositionKt$solve$22 = false;
            String $i$a$-require-LupDecompositionKt$solve$22 = "Matrix dimension mismatch. Expected " + $this$solve.getPivot().length + ", but got " + matrix.getColNum();
            throw new IllegalArgumentException($i$a$-require-LupDecompositionKt$solve$22.toString());
        }
        BufferAccessor2D<T> $this$solve_u24lambda_u2410 = new BufferAccessor2D<T>(matrix.getRowNum(), matrix.getColNum(), factory);
        boolean bl = false;
        Algebra $this$invoke$iv = $this$solve.getElementContext();
        boolean $i$f$invoke = false;
        Field $this$solve_u24lambda_u2410_u24lambda_u249 = (Field)$this$invoke$iv;
        boolean bl2 = false;
        BufferAccessor2D<T> this_$iv = $this$solve_u24lambda_u2410;
        int $i$f$create = 0;
        MutableBuffer<T> bp = this_$iv.getFactory().invoke(this_$iv.getRowNum() * this_$iv.getColNum(), (Function1)new Function1<Integer, T>(this_$iv, $this$solve_u24lambda_u2410_u24lambda_u249){
            final /* synthetic */ BufferAccessor2D this$0;
            final /* synthetic */ Field $this_invoke$inlined;
            {
                this.this$0 = $receiver;
                this.$this_invoke$inlined = field;
                super(1);
            }

            public final T invoke(int offset) {
                int cfr_ignored_0 = offset / this.this$0.getColNum();
                int cfr_ignored_1 = offset % this.this$0.getColNum();
                boolean bl = false;
                return this.$this_invoke$inlined.getZero();
            }
        });
        $i$f$create = $this$solve.getPivot().length;
        for (int row2 = 0; row2 < $i$f$create; ++row2) {
            BufferAccessor2D.Row bpRow = $this$solve_u24lambda_u2410.row(bp, row2);
            int pRow = $this$solve.getPivot()[row2];
            int n2 = matrix.getColNum();
            for (col22 = 0; col22 < n2; ++col22) {
                bpRow.set(col22, matrix.get(pRow, col22));
            }
        }
        $i$f$create = $this$solve.getPivot().length;
        for (col = 0; col < $i$f$create; ++col) {
            BufferAccessor2D.Row bpCol = $this$solve_u24lambda_u2410.row(bp, col);
            col22 = $this$solve.getPivot().length;
            for (i = col + 1; i < col22; ++i) {
                BufferAccessor2D.Row bpI = $this$solve_u24lambda_u2410.row(bp, i);
                T luICol = $this$solve.getLu().get(i, col);
                n = matrix.getColNum();
                for (int j = 0; j < n; ++j) {
                    int n3 = j;
                    bpI.set(n3, $this$solve_u24lambda_u2410_u24lambda_u249.minus(bpI.get(n3), $this$solve_u24lambda_u2410_u24lambda_u249.times(bpCol.get(j), luICol)));
                }
            }
        }
        for (col = $this$solve.getPivot().length - 1; -1 < col; --col) {
            BufferAccessor2D.Row bpCol = $this$solve_u24lambda_u2410.row(bp, col);
            T luDiag = $this$solve.getLu().get(col, col);
            int j = 0;
            int col22 = matrix.getColNum();
            while (j < col22) {
                int bpI = j++;
                bpCol.set(bpI, $this$solve_u24lambda_u2410_u24lambda_u249.div(bpCol.get(bpI), luDiag));
            }
            for (i = 0; i < col; ++i) {
                BufferAccessor2D.Row bpI = $this$solve_u24lambda_u2410.row(bp, i);
                T luICol = $this$solve.getLu().get(i, col);
                int n4 = matrix.getColNum();
                for (int j2 = 0; j2 < n4; ++j2) {
                    n = j2;
                    bpI.set(n, $this$solve_u24lambda_u2410_u24lambda_u249.minus(bpI.get(n), $this$solve_u24lambda_u2410_u24lambda_u249.times(bpCol.get(j2), luICol)));
                }
            }
        }
        return $this$solve.getContext().buildMatrix($this$solve.getPivot().length, matrix.getColNum(), (arg_0, arg_1, arg_2) -> LupDecompositionKt.solve$lambda$10$lambda$9$lambda$8($this$solve_u24lambda_u2410, bp, arg_0, arg_1, arg_2));
    }

    @NotNull
    public static final <T extends Comparable<? super T>, F extends Field<T>> LinearSolver<T> lupSolver(@NotNull LinearSpace<T, ? extends F> $this$lupSolver, @NotNull MutableBufferFactory<T> bufferFactory2, @NotNull Function1<? super T, Boolean> singularityCheck) {
        Intrinsics.checkNotNullParameter($this$lupSolver, (String)"<this>");
        Intrinsics.checkNotNullParameter(bufferFactory2, (String)"bufferFactory");
        Intrinsics.checkNotNullParameter(singularityCheck, (String)"singularityCheck");
        return new LinearSolver<T>($this$lupSolver, bufferFactory2, singularityCheck){
            final /* synthetic */ LinearSpace<T, F> $this_lupSolver;
            final /* synthetic */ MutableBufferFactory<T> $bufferFactory;
            final /* synthetic */ Function1<T, Boolean> $singularityCheck;
            {
                this.$this_lupSolver = $receiver;
                this.$bufferFactory = $bufferFactory;
                this.$singularityCheck = $singularityCheck;
            }

            @NotNull
            public Structure2D<T> solve(@NotNull Structure2D<? extends T> a, @NotNull Structure2D<? extends T> b) {
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                LinearSpace<? extends T, F> $this$computeFeature$iv = this.$this_lupSolver;
                boolean $i$f$computeFeature = false;
                LupDecomposition<? extends T> lupDecomposition = (LupDecomposition<? extends T>)$this$computeFeature$iv.computeFeature(a, Reflection.getOrCreateKotlinClass(LupDecomposition.class));
                if (lupDecomposition == null) {
                    lupDecomposition = LupDecompositionKt.lup(this.$this_lupSolver, this.$bufferFactory, a, this.$singularityCheck);
                }
                LupDecomposition<? extends T> decomposition = lupDecomposition;
                return LupDecompositionKt.solve(decomposition, this.$bufferFactory, b);
            }

            @NotNull
            public Structure2D<T> inverse(@NotNull Structure2D<? extends T> matrix) {
                Intrinsics.checkNotNullParameter(matrix, (String)"matrix");
                return this.solve(matrix, MatrixWrapperKt.one(this.$this_lupSolver, matrix.getRowNum(), matrix.getColNum()));
            }
        };
    }

    @NotNull
    public static final LinearSolver<Double> lupSolver(@NotNull LinearSpace<Double, DoubleField> $this$lupSolver, double singularityThreshold) {
        Intrinsics.checkNotNullParameter($this$lupSolver, (String)"<this>");
        return LupDecompositionKt.lupSolver($this$lupSolver, lupSolver.2.INSTANCE, arg_0 -> LupDecompositionKt.lupSolver$lambda$11(singularityThreshold, arg_0));
    }

    public static /* synthetic */ LinearSolver lupSolver$default(LinearSpace linearSpace, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0E-11;
        }
        return LupDecompositionKt.lupSolver(linearSpace, d);
    }

    private static final boolean lup$lambda$5(double $singularityThreshold, double it) {
        return it < $singularityThreshold;
    }

    private static final Object solve$lambda$10$lambda$9$lambda$8(BufferAccessor2D $this_run, MutableBuffer $bp, Ring $this$buildMatrix, int i, int j) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)$bp, (String)"$bp");
        Intrinsics.checkNotNullParameter((Object)$this$buildMatrix, (String)"$this$buildMatrix");
        return $this_run.get($bp, i, j);
    }

    private static final boolean lupSolver$lambda$11(double $singularityThreshold, double it) {
        return it < $singularityThreshold;
    }
}

