/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.operations;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.PerformancePitfall;
import space.kscience.kmath.operations.Group;
import space.kscience.kmath.operations.ScaleOperations;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0002H\u0001\"\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\u0004\u001a\u0002H\u0001\u00a2\u0006\u0002\u0010\u0005\u001a=\u0010\u0006\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\u0018\b\u0001\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\b*\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001a=\u0010\u0006\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\u0018\b\u0001\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\b*\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\f\u00a2\u0006\u0002\u0010\r\u001a?\u0010\u0006\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\u0018\b\u0001\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\b*\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a=\u0010\u0010\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\u0018\b\u0001\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\b*\b\u0012\u0004\u0012\u0002H\u00010\n2\u0006\u0010\u0011\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u0012\u001a=\u0010\u0010\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001\"\u0018\b\u0001\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\b*\b\u0012\u0004\u0012\u0002H\u00010\f2\u0006\u0010\u0011\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u0013\u001a)\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001a)\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\f\u00a2\u0006\u0002\u0010\r\u001a+\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a)\u0010\u0015\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003\u00a2\u0006\u0002\u0010\u0012\u001a)\u0010\u0015\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003\u00a2\u0006\u0002\u0010\u0013\u001aI\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0001\"\u0004\b\u0001\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00180\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"abs", "T", "", "Lspace/kscience/kmath/operations/Group;", "value", "(Lspace/kscience/kmath/operations/Group;Ljava/lang/Comparable;)Ljava/lang/Comparable;", "average", "S", "Lspace/kscience/kmath/operations/ScaleOperations;", "data", "", "(Lspace/kscience/kmath/operations/Group;Ljava/lang/Iterable;)Ljava/lang/Object;", "Lkotlin/sequences/Sequence;", "(Lspace/kscience/kmath/operations/Group;Lkotlin/sequences/Sequence;)Ljava/lang/Object;", "Lspace/kscience/kmath/structures/Buffer;", "(Lspace/kscience/kmath/operations/Group;Lspace/kscience/kmath/structures/Buffer;)Ljava/lang/Object;", "averageWith", "space", "(Ljava/lang/Iterable;Lspace/kscience/kmath/operations/Group;)Ljava/lang/Object;", "(Lkotlin/sequences/Sequence;Lspace/kscience/kmath/operations/Group;)Ljava/lang/Object;", "sum", "sumWith", "group", "sumWithGroupOf", "R", "extractor", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Lspace/kscience/kmath/operations/Group;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nalgebraExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 algebraExtensions.kt\nspace/kscience/kmath/operations/AlgebraExtensionsKt\n+ 2 bufferExtensions.kt\nspace/kscience/kmath/operations/BufferExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,136:1\n101#2,4:137\n1789#3,3:141\n1789#3,3:147\n1266#4,3:144\n*S KotlinDebug\n*F\n+ 1 algebraExtensions.kt\nspace/kscience/kmath/operations/AlgebraExtensionsKt\n*L\n19#1:137,4\n30#1:141,3\n102#1:147,3\n43#1:144,3\n*E\n"})
public final class AlgebraExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @PerformancePitfall(message="Potential boxing access to buffer elements")
    public static final <T> T sum(@NotNull Group<T> $this$sum, @NotNull Buffer<? extends T> data) {
        T t;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Buffer<? extends T> buffer = data;
        T initial$iv = $this$sum.getZero();
        boolean $i$f$fold = false;
        if ($this$fold$iv.getSize() == 0) {
            t = initial$iv;
        } else {
            int n;
            T accumulator$iv = initial$iv;
            IntRange intRange = BufferKt.getIndices($this$fold$iv);
            int index$iv = intRange.getFirst();
            if (index$iv <= (n = intRange.getLast())) {
                while (true) {
                    void right;
                    Object t2 = $this$fold$iv.get(index$iv);
                    T left = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = $this$sum.add((void)left, right);
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            t = accumulator$iv;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T sum(@NotNull Group<T> $this$sum, @NotNull Iterable<? extends T> data) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable<? extends T> iterable = data;
        T initial$iv = $this$sum.getZero();
        boolean $i$f$fold = false;
        T accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void right;
            Object element$iv;
            Object t = element$iv = iterator2.next();
            T left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = $this$sum.add((void)left, right);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T sum(@NotNull Group<T> $this$sum, @NotNull Sequence<? extends T> data) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Sequence<? extends T> sequence = data;
        T initial$iv = $this$sum.getZero();
        boolean $i$f$fold = false;
        T accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void right;
            Object element$iv;
            Object e = element$iv = iterator2.next();
            T left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = $this$sum.add((void)left, right);
        }
        return accumulator$iv;
    }

    @PerformancePitfall(message="Potential boxing access to buffer elements")
    public static final <T, S extends Group<T> & ScaleOperations<T>> T average(@NotNull S $this$average, @NotNull Buffer<? extends T> data) {
        Intrinsics.checkNotNullParameter($this$average, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return ((ScaleOperations<T>)$this$average).div(AlgebraExtensionsKt.sum($this$average, data), data.getSize());
    }

    public static final <T, S extends Group<T> & ScaleOperations<T>> T average(@NotNull S $this$average, @NotNull Iterable<? extends T> data) {
        Intrinsics.checkNotNullParameter($this$average, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return ((ScaleOperations<T>)$this$average).div(AlgebraExtensionsKt.sum($this$average, data), CollectionsKt.count(data));
    }

    public static final <T, S extends Group<T> & ScaleOperations<T>> T average(@NotNull S $this$average, @NotNull Sequence<? extends T> data) {
        Intrinsics.checkNotNullParameter($this$average, (String)"<this>");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return ((ScaleOperations<T>)$this$average).div(AlgebraExtensionsKt.sum($this$average, data), SequencesKt.count(data));
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T abs(@NotNull Group<T> $this$abs, @NotNull T value) {
        Intrinsics.checkNotNullParameter($this$abs, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return (T)(value.compareTo($this$abs.getZero()) > 0 ? value : $this$abs.unaryMinus(value));
    }

    public static final <T> T sumWith(@NotNull Iterable<? extends T> $this$sumWith, @NotNull Group<T> group) {
        Intrinsics.checkNotNullParameter($this$sumWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        return AlgebraExtensionsKt.sum(group, $this$sumWith);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T, R> R sumWithGroupOf(@NotNull Iterable<? extends T> $this$sumWithGroupOf, @NotNull Group<R> group, @NotNull Function1<? super T, ? extends R> extractor) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$sumWithGroupOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        boolean $i$f$sumWithGroupOf = false;
        Iterable<? extends T> iterable = $this$sumWithGroupOf;
        R initial$iv = group.getZero();
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void right;
            Object element$iv;
            Object t = element$iv = iterator2.next();
            R left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = group.add(left, extractor.invoke((Object)right));
        }
        return accumulator$iv;
    }

    public static final <T> T sumWith(@NotNull Sequence<? extends T> $this$sumWith, @NotNull Group<T> group) {
        Intrinsics.checkNotNullParameter($this$sumWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        return AlgebraExtensionsKt.sum(group, $this$sumWith);
    }

    public static final <T, S extends Group<T> & ScaleOperations<T>> T averageWith(@NotNull Iterable<? extends T> $this$averageWith, @NotNull S space) {
        Intrinsics.checkNotNullParameter($this$averageWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(space, (String)"space");
        return AlgebraExtensionsKt.average(space, $this$averageWith);
    }

    public static final <T, S extends Group<T> & ScaleOperations<T>> T averageWith(@NotNull Sequence<? extends T> $this$averageWith, @NotNull S space) {
        Intrinsics.checkNotNullParameter($this$averageWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(space, (String)"space");
        return AlgebraExtensionsKt.average(space, $this$averageWith);
    }
}

