/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.operations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.operations.BigInt;
import space.kscience.kmath.operations.BigIntKt;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.operations.NumbersAddOps;
import space.kscience.kmath.operations.ScaleOperations;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00020\u0002*\u00020\u0017H\u0086\u0002J\r\u0010\u0016\u001a\u00020\u0002*\u00020\u0002H\u0096\u0002J\r\u0010\u0018\u001a\u00020\u0002*\u00020\u0017H\u0086\u0002R\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0019"}, d2={"Lspace/kscience/kmath/operations/BigIntField;", "Lspace/kscience/kmath/operations/Field;", "Lspace/kscience/kmath/operations/BigInt;", "Lspace/kscience/kmath/operations/NumbersAddOps;", "Lspace/kscience/kmath/operations/ScaleOperations;", "()V", "one", "getOne", "()Lspace/kscience/kmath/operations/BigInt;", "zero", "getZero", "add", "left", "right", "divide", "multiply", "number", "value", "", "scale", "a", "", "unaryMinus", "", "unaryPlus", "kmath-core"})
public final class BigIntField
implements Field<BigInt>,
NumbersAddOps<BigInt>,
ScaleOperations<BigInt> {
    @NotNull
    public static final BigIntField INSTANCE = new BigIntField();
    @NotNull
    private static final BigInt zero = BigInt.Companion.getZERO();
    @NotNull
    private static final BigInt one = BigInt.Companion.getONE();

    private BigIntField() {
    }

    @Override
    @NotNull
    public BigInt getZero() {
        return zero;
    }

    @Override
    @NotNull
    public BigInt getOne() {
        return one;
    }

    @Override
    @NotNull
    public BigInt number(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return BigIntKt.toBigInt(value.longValue());
    }

    @Override
    @NotNull
    public BigInt unaryMinus(@NotNull BigInt $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return $this$unaryMinus.unaryMinus();
    }

    @Override
    @NotNull
    public BigInt add(@NotNull BigInt left, @NotNull BigInt right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return left.plus(right);
    }

    @Override
    @NotNull
    public BigInt scale(@NotNull BigInt a, double value) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return a.times(this.number(value));
    }

    @Override
    @NotNull
    public BigInt multiply(@NotNull BigInt left, @NotNull BigInt right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return left.times(right);
    }

    @Override
    @NotNull
    public BigInt divide(@NotNull BigInt left, @NotNull BigInt right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return left.div(right);
    }

    @Override
    @NotNull
    public final BigInt unaryPlus(@NotNull String $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        BigInt bigInt = BigIntKt.parseBigInteger($this$unaryPlus);
        if (bigInt == null) {
            throw new IllegalStateException(("Can't parse " + $this$unaryPlus + " as big integer").toString());
        }
        return bigInt;
    }

    @Override
    @NotNull
    public final BigInt unaryMinus(@NotNull String $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        BigInt bigInt = BigIntKt.parseBigInteger($this$unaryMinus);
        if (bigInt == null) {
            throw new IllegalStateException(("Can't parse " + $this$unaryMinus + " as big integer").toString());
        }
        return bigInt.unaryMinus();
    }
}

