/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.operations;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.operations.DoubleBufferOps;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a8\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0086\b\u00f8\u0001\u0000\u001a&\u0010\t\u001a\u00020\u0001*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u0018\u0010\f\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u0018\u0010\r\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u0018\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a8\u0010\u000f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"average", "", "Lspace/kscience/kmath/operations/DoubleBufferOps;", "buffer", "Lspace/kscience/kmath/structures/Buffer;", "averageOf", "T", "conversion", "Lkotlin/Function1;", "covariance", "x", "y", "dispersion", "std", "sum", "sumOf", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nDoubleBufferOps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleBufferOps.kt\nspace/kscience/kmath/operations/DoubleBufferOpsKt\n+ 2 bufferExtensions.kt\nspace/kscience/kmath/operations/BufferExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n174#1:215\n121#2:204\n122#2,5:206\n101#2,4:211\n101#2,4:216\n101#2,4:220\n1#3:205\n1#3:224\n1855#4,2:225\n*S KotlinDebug\n*F\n+ 1 DoubleBufferOps.kt\nspace/kscience/kmath/operations/DoubleBufferOpsKt\n*L\n182#1:215\n168#1:204\n168#1:206,5\n174#1:211,4\n182#1:216,4\n186#1:220,4\n168#1:205\n196#1:225,2\n*E\n"})
public final class DoubleBufferOpsKt {
    /*
     * WARNING - void declaration
     */
    public static final double sum(@NotNull DoubleBufferOps $this$sum, @NotNull Buffer<Double> buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        Buffer<Double> $this$reduce$iv = buffer;
        boolean $i$f$reduce = false;
        if (!($this$reduce$iv.getSize() > 0)) {
            boolean $i$a$-require-BufferExtensionsKt$reduce$1$iv22 = false;
            String $i$a$-require-BufferExtensionsKt$reduce$1$iv22 = "Buffer must have elements";
            throw new IllegalArgumentException($i$a$-require-BufferExtensionsKt$reduce$1$iv22.toString());
        }
        Double current$iv = $this$reduce$iv.get(0);
        int n = $this$reduce$iv.getSize();
        for (int i$iv = 1; i$iv < n; ++i$iv) {
            void p1;
            double d = ((Number)$this$reduce$iv.get(i$iv)).doubleValue();
            double p0 = ((Number)current$iv).doubleValue();
            boolean bl = false;
            current$iv = p0 + p1;
        }
        return ((Number)current$iv).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> double sumOf(@NotNull DoubleBufferOps $this$sumOf, @NotNull Buffer<? extends T> buffer, @NotNull Function1<? super T, Double> conversion) {
        double d;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sumOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(conversion, (String)"conversion");
        boolean $i$f$sumOf = false;
        Buffer<? extends T> buffer2 = buffer;
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        if ($this$fold$iv.getSize() == 0) {
            d = initial$iv;
        } else {
            int n;
            double accumulator$iv = initial$iv;
            IntRange intRange = BufferKt.getIndices($this$fold$iv);
            int index$iv = intRange.getFirst();
            if (index$iv <= (n = intRange.getLast())) {
                while (true) {
                    void value;
                    Object t = $this$fold$iv.get(index$iv);
                    double acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc + ((Number)conversion.invoke((Object)value)).doubleValue();
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            d = accumulator$iv;
        }
        return d;
    }

    public static final double average(@NotNull DoubleBufferOps $this$average, @NotNull Buffer<Double> buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$average, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        return DoubleBufferOpsKt.sum($this$average, buffer) / (double)buffer.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> double averageOf(@NotNull DoubleBufferOps $this$averageOf, @NotNull Buffer<? extends T> buffer, @NotNull Function1<? super T, Double> conversion) {
        double d;
        void $this$fold$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$averageOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(conversion, (String)"conversion");
        boolean $i$f$averageOf = false;
        DoubleBufferOps $this$sumOf$iv = $this$averageOf;
        boolean $i$f$sumOf = false;
        Buffer<T> buffer2 = buffer;
        double initial$iv$iv = 0.0;
        boolean $i$f$fold = false;
        if ($this$fold$iv$iv.getSize() == 0) {
            d = initial$iv$iv;
        } else {
            int n;
            double accumulator$iv$iv = initial$iv$iv;
            IntRange intRange = BufferKt.getIndices($this$fold$iv$iv);
            int index$iv$iv = intRange.getFirst();
            if (index$iv$iv <= (n = intRange.getLast())) {
                while (true) {
                    void value$iv;
                    Object t = $this$fold$iv$iv.get(index$iv$iv);
                    double acc$iv = accumulator$iv$iv;
                    boolean bl = false;
                    accumulator$iv$iv = acc$iv + ((Number)conversion.invoke((Object)value$iv)).doubleValue();
                    if (index$iv$iv == n) break;
                    ++index$iv$iv;
                }
            }
            d = accumulator$iv$iv;
        }
        return d / (double)buffer.getSize();
    }

    /*
     * WARNING - void declaration
     */
    public static final double dispersion(@NotNull DoubleBufferOps $this$dispersion, @NotNull Buffer<Double> buffer) {
        double d;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$dispersion, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        double av = DoubleBufferOpsKt.average($this$dispersion, buffer);
        Buffer<Double> buffer2 = buffer;
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        if ($this$fold$iv.getSize() == 0) {
            d = initial$iv;
        } else {
            int n;
            double accumulator$iv = initial$iv;
            IntRange intRange = BufferKt.getIndices($this$fold$iv);
            int index$iv = intRange.getFirst();
            if (index$iv <= (n = intRange.getLast())) {
                while (true) {
                    void value;
                    double d2 = ((Number)$this$fold$iv.get(index$iv)).doubleValue();
                    double acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc + Math.pow((double)(value - av), 2);
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            d = accumulator$iv;
        }
        return d / (double)buffer.getSize();
    }

    public static final double std(@NotNull DoubleBufferOps $this$std, @NotNull Buffer<Double> buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$std, (String)"<this>");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        return Math.sqrt(DoubleBufferOpsKt.dispersion($this$std, buffer));
    }

    public static final double covariance(@NotNull DoubleBufferOps $this$covariance, @NotNull Buffer<Double> x, @NotNull Buffer<Double> y) {
        Intrinsics.checkNotNullParameter((Object)$this$covariance, (String)"<this>");
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        if (!(x.getSize() == y.getSize())) {
            boolean bl = false;
            String string = "Expected buffers of the same size, but x.size == " + x.getSize() + " and y.size == " + y.getSize();
            throw new IllegalArgumentException(string.toString());
        }
        double xMean = DoubleBufferOpsKt.average($this$covariance, x);
        double yMean = DoubleBufferOpsKt.average($this$covariance, y);
        double sum = 0.0;
        Iterable $this$forEach$iv = (Iterable)BufferKt.getIndices(x);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            sum += (((Number)x.get(it)).doubleValue() - xMean) * (((Number)y.get(it)).doubleValue() - yMean);
        }
        return sum / (double)(x.getSize() - 1);
    }
}

