/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.operations;

import java.math.BigDecimal;
import java.math.MathContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.operations.Field;
import space.kscience.kmath.operations.NumericAlgebra;
import space.kscience.kmath.operations.PowerOperations;
import space.kscience.kmath.operations.ScaleOperations;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u00042\b\u0012\u0004\u0012\u00020\u00020\u0005B\u0011\b\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0015\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0096\u0002J\r\u0010\u001e\u001a\u00020\u0002*\u00020\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lspace/kscience/kmath/operations/JBigDecimalFieldBase;", "Lspace/kscience/kmath/operations/Field;", "Ljava/math/BigDecimal;", "Lspace/kscience/kmath/operations/PowerOperations;", "Lspace/kscience/kmath/operations/NumericAlgebra;", "Lspace/kscience/kmath/operations/ScaleOperations;", "mathContext", "Ljava/math/MathContext;", "(Ljava/math/MathContext;)V", "one", "getOne", "()Ljava/math/BigDecimal;", "zero", "getZero", "add", "left", "right", "divide", "multiply", "number", "value", "", "power", "arg", "pow", "scale", "a", "", "sqrt", "minus", "unaryMinus", "kmath-core"})
public abstract class JBigDecimalFieldBase
implements Field<BigDecimal>,
PowerOperations<BigDecimal>,
NumericAlgebra<BigDecimal>,
ScaleOperations<BigDecimal> {
    @NotNull
    private final MathContext mathContext;

    public JBigDecimalFieldBase(@NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        this.mathContext = mathContext;
    }

    public /* synthetic */ JBigDecimalFieldBase(MathContext mathContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            MathContext mathContext2 = MathContext.DECIMAL64;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"DECIMAL64");
            mathContext = mathContext2;
        }
        this(mathContext);
    }

    @Override
    @NotNull
    public BigDecimal getZero() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal getOne() {
        BigDecimal bigDecimal = BigDecimal.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ONE");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal add(@NotNull BigDecimal left, @NotNull BigDecimal right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        BigDecimal bigDecimal = left.add(right);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"left.add(right)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal minus(@NotNull BigDecimal $this$minus, @NotNull BigDecimal arg) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        BigDecimal bigDecimal = $this$minus.subtract(arg);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(arg)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal number(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BigDecimal bigDecimal = BigDecimal.valueOf(value.doubleValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(value.toDouble())");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal scale(@NotNull BigDecimal a, double value) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double d = value;
        MathContext mathContext = this.mathContext;
        BigDecimal bigDecimal = a.multiply(new BigDecimal(String.valueOf(d), mathContext), this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"a.multiply(value.toBigDe\u2026athContext), mathContext)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal multiply(@NotNull BigDecimal left, @NotNull BigDecimal right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        BigDecimal bigDecimal = left.multiply(right, this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"left.multiply(right, mathContext)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal divide(@NotNull BigDecimal left, @NotNull BigDecimal right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        BigDecimal bigDecimal = left.divide(right, this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"left.divide(right, mathContext)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal power(@NotNull BigDecimal arg, @NotNull Number pow) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)pow, (String)"pow");
        BigDecimal bigDecimal = arg.pow(pow.intValue(), this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"arg.pow(pow.toInt(), mathContext)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal sqrt(@NotNull BigDecimal arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        BigDecimal bigDecimal = arg.sqrt(this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"arg.sqrt(mathContext)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal unaryMinus(@NotNull BigDecimal $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        BigDecimal bigDecimal = $this$unaryMinus.negate(this.mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"negate(mathContext)");
        return bigDecimal;
    }

    public JBigDecimalFieldBase() {
        this(null, 1, null);
    }
}

