/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.operations;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.operations.NumericAlgebra;
import space.kscience.kmath.operations.Ring;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0096\u0002J\r\u0010\u0013\u001a\u00020\u0002*\u00020\u0002H\u0096\u0002R\u0014\u0010\u0005\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lspace/kscience/kmath/operations/JBigIntegerField;", "Lspace/kscience/kmath/operations/Ring;", "Ljava/math/BigInteger;", "Lspace/kscience/kmath/operations/NumericAlgebra;", "()V", "one", "getOne", "()Ljava/math/BigInteger;", "zero", "getZero", "add", "left", "right", "multiply", "number", "value", "", "minus", "arg", "unaryMinus", "kmath-core"})
public final class JBigIntegerField
implements Ring<BigInteger>,
NumericAlgebra<BigInteger> {
    @NotNull
    public static final JBigIntegerField INSTANCE = new JBigIntegerField();

    private JBigIntegerField() {
    }

    @Override
    @NotNull
    public BigInteger getZero() {
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger getOne() {
        BigInteger bigInteger = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger number(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BigInteger bigInteger = BigInteger.valueOf(value.longValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(value.toLong())");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger add(@NotNull BigInteger left, @NotNull BigInteger right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        BigInteger bigInteger = left.add(right);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"left.add(right)");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger minus(@NotNull BigInteger $this$minus, @NotNull BigInteger arg) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        BigInteger bigInteger = $this$minus.subtract(arg);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(arg)");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger multiply(@NotNull BigInteger left, @NotNull BigInteger right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        BigInteger bigInteger = left.multiply(right);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"left.multiply(right)");
        return bigInteger;
    }

    @Override
    @NotNull
    public BigInteger unaryMinus(@NotNull BigInteger $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        BigInteger bigInteger = $this$unaryMinus.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate()");
        return bigInteger;
    }
}

