/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.MutableBuffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u0016\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lspace/kscience/kmath/structures/ArrayBuffer;", "T", "Lspace/kscience/kmath/structures/MutableBuffer;", "array", "", "([Ljava/lang/Object;)V", "getArray$kmath_core", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "size", "", "getSize", "()I", "copy", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "set", "", "value", "(ILjava/lang/Object;)V", "toString", "", "kmath-core"})
public final class ArrayBuffer<T>
implements MutableBuffer<T> {
    @NotNull
    private final T[] array;

    public ArrayBuffer(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.array = array;
    }

    @NotNull
    public final T[] getArray$kmath_core() {
        return this.array;
    }

    @Override
    public int getSize() {
        return this.array.length;
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, T value) {
        this.array[index] = value;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return ArrayIteratorKt.iterator((Object[])this.array);
    }

    @Override
    @NotNull
    public MutableBuffer<T> copy() {
        T[] TArray = Arrays.copyOf(this.array, this.array.length);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(this, size)");
        return new ArrayBuffer<T>(TArray);
    }

    @Override
    @NotNull
    public String toString() {
        return Buffer.Companion.toString(this);
    }
}

