/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferView;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0016"}, d2={"Lspace/kscience/kmath/structures/BufferSlice;", "T", "Lspace/kscience/kmath/structures/BufferView;", "origin", "Lspace/kscience/kmath/structures/Buffer;", "offset", "", "size", "(Lspace/kscience/kmath/structures/Buffer;II)V", "getOffset", "()I", "getOrigin", "()Lspace/kscience/kmath/structures/Buffer;", "getSize", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "originIndex", "toString", "", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nBufferView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferView.kt\nspace/kscience/kmath/structures/BufferSlice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class BufferSlice<T>
implements BufferView<T> {
    @NotNull
    private final Buffer<T> origin;
    private final int offset;
    private final int size;

    public BufferSlice(@NotNull Buffer<? extends T> origin, int offset, int size) {
        Intrinsics.checkNotNullParameter(origin, (String)"origin");
        this.origin = origin;
        this.offset = offset;
        this.size = size;
        if (!(this.getSize() > 0)) {
            boolean $i$a$-require-BufferSlice$32 = false;
            String $i$a$-require-BufferSlice$32 = "Size must be positive";
            throw new IllegalArgumentException($i$a$-require-BufferSlice$32.toString());
        }
        if (!(this.offset + this.getSize() <= this.getOrigin().getSize())) {
            boolean bl = false;
            String string = "End of buffer " + (this.offset + this.getSize()) + " is beyond the end of origin buffer size " + this.getOrigin().getSize();
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ BufferSlice(Buffer buffer, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        this(buffer, n, n2);
    }

    @Override
    @NotNull
    public Buffer<T> getOrigin() {
        return this.origin;
    }

    public final int getOffset() {
        return this.offset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public T get(int index) {
        if (index >= this.getSize()) {
            throw new IndexOutOfBoundsException(index + " is out of " + RangesKt.until((int)0, (int)this.getSize()) + " rage");
        }
        return this.getOrigin().get(index + this.offset);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)this.offset, (int)(this.offset + this.getSize())))), arg_0 -> BufferSlice.iterator$lambda$2(this, arg_0)).iterator();
    }

    @Override
    @UnstableKMathAPI
    public int originIndex(int index) {
        return index >= this.getSize() ? -1 : index - this.offset;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getOrigin() + "[" + this.offset + ".." + (this.offset + this.getSize());
    }

    private static final Object iterator$lambda$2(BufferSlice this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getOrigin().get(it);
    }
}

