/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.FlaggedBuffer;
import space.kscience.kmath.structures.FlaggedBufferKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0011\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lspace/kscience/kmath/structures/FlaggedDoubleBuffer;", "Lspace/kscience/kmath/structures/FlaggedBuffer;", "", "Lspace/kscience/kmath/structures/Buffer;", "values", "", "flags", "", "([D[B)V", "getFlags", "()[B", "size", "", "getSize", "()I", "getValues", "()[D", "get", "index", "(I)Ljava/lang/Double;", "getFlag", "", "iterator", "", "toString", "", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nFlaggedBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaggedBuffer.kt\nspace/kscience/kmath/structures/FlaggedDoubleBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class FlaggedDoubleBuffer
implements FlaggedBuffer<Double>,
Buffer<Double> {
    @NotNull
    private final double[] values;
    @NotNull
    private final byte[] flags;

    public FlaggedDoubleBuffer(@NotNull double[] values, @NotNull byte[] flags) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this.values = values;
        this.flags = flags;
        if (!(this.values.length == this.flags.length)) {
            boolean bl = false;
            String string = "Values and flags must have the same dimensions";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final double[] getValues() {
        return this.values;
    }

    @NotNull
    public final byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte getFlag(int index) {
        return this.flags[index];
    }

    @Override
    public int getSize() {
        return this.values.length;
    }

    @Override
    @Nullable
    public Double get(int index) {
        return FlaggedBufferKt.isValid(this, index) ? Double.valueOf(this.values[index]) : null;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ArraysKt.getIndices((double[])this.values))), arg_0 -> FlaggedDoubleBuffer.iterator$lambda$1(this, arg_0)).iterator();
    }

    @Override
    @NotNull
    public String toString() {
        return Buffer.Companion.toString(this);
    }

    private static final Double iterator$lambda$1(FlaggedDoubleBuffer this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return FlaggedBufferKt.isValid(this$0, it) ? Double.valueOf(this$0.values[it]) : null;
    }
}

