/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.structures.Buffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007B\u0013\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lspace/kscience/kmath/structures/ListBuffer;", "T", "Lspace/kscience/kmath/structures/Buffer;", "size", "", "initializer", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)V", "list", "", "(Ljava/util/List;)V", "getList", "()Ljava/util/List;", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "toString", "", "kmath-core"})
public final class ListBuffer<T>
implements Buffer<T> {
    @NotNull
    private final List<T> list;

    public ListBuffer(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.list = list;
    }

    @NotNull
    public final List<T> getList() {
        return this.list;
    }

    public ListBuffer(int size, @NotNull Function1<? super Integer, ? extends T> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        ListBuffer<T> listBuffer = this;
        ArrayList<Object> arrayList = new ArrayList<Object>(size);
        int n = 0;
        while (n < size) {
            int n2 = n++;
            arrayList.add(initializer.invoke((Object)n2));
        }
        listBuffer((List)arrayList);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    @NotNull
    public String toString() {
        return Buffer.Companion.toString(this);
    }
}

