/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.BufferKt;
import space.kscience.kmath.structures.BufferView;
import space.kscience.kmath.structures.MutableBuffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0017J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lspace/kscience/kmath/structures/PermutedMutableBuffer;", "T", "Lspace/kscience/kmath/structures/BufferView;", "Lspace/kscience/kmath/structures/MutableBuffer;", "origin", "permutations", "", "(Lspace/kscience/kmath/structures/MutableBuffer;[I)V", "getOrigin", "()Lspace/kscience/kmath/structures/MutableBuffer;", "size", "", "getSize", "()I", "copy", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "originIndex", "set", "", "value", "(ILjava/lang/Object;)V", "toString", "", "kmath-core"})
@SourceDebugExtension(value={"SMAP\nBufferView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferView.kt\nspace/kscience/kmath/structures/PermutedMutableBuffer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n13600#2,2:193\n*S KotlinDebug\n*F\n+ 1 BufferView.kt\nspace/kscience/kmath/structures/PermutedMutableBuffer\n*L\n162#1:193,2\n*E\n"})
public final class PermutedMutableBuffer<T>
implements BufferView<T>,
MutableBuffer<T> {
    @NotNull
    private final MutableBuffer<T> origin;
    @NotNull
    private final int[] permutations;

    public PermutedMutableBuffer(@NotNull MutableBuffer<T> origin, @NotNull int[] permutations) {
        Intrinsics.checkNotNullParameter(origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)permutations, (String)"permutations");
        this.origin = origin;
        this.permutations = permutations;
        int[] $this$forEach$iv = this.permutations;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int index = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            IntRange intRange = BufferKt.getIndices(this.getOrigin());
            int n2 = intRange.getFirst();
            if (index <= intRange.getLast() ? n2 <= index : false) continue;
            throw new IndexOutOfBoundsException("Index " + index + " is not in " + BufferKt.getIndices(this.getOrigin()));
        }
    }

    @Override
    @NotNull
    public MutableBuffer<T> getOrigin() {
        return this.origin;
    }

    @Override
    public int getSize() {
        return this.permutations.length;
    }

    @Override
    public T get(int index) {
        return this.getOrigin().get(this.permutations[index]);
    }

    @Override
    public void set(int index, T value) {
        this.getOrigin().set(this.permutations[index], value);
    }

    @Override
    @NotNull
    public MutableBuffer<T> copy() {
        return new PermutedMutableBuffer(this.getOrigin().copy(), this.permutations);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return SequencesKt.map((Sequence)ArraysKt.asSequence((int[])this.permutations), arg_0 -> PermutedMutableBuffer.iterator$lambda$1(this, arg_0)).iterator();
    }

    @Override
    @UnstableKMathAPI
    public int originIndex(int index) {
        return (0 <= index ? index < this.permutations.length : false) ? this.permutations[index] : -1;
    }

    @Override
    @NotNull
    public String toString() {
        return Buffer.Companion.toString(this);
    }

    private static final Object iterator$lambda$1(PermutedMutableBuffer this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getOrigin().get(it);
    }
}

