/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.structures;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.structures.Buffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lspace/kscience/kmath/structures/VirtualBuffer;", "T", "Lspace/kscience/kmath/structures/Buffer;", "size", "", "generator", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)V", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "iterator", "", "toString", "", "kmath-core"})
public final class VirtualBuffer<T>
implements Buffer<T> {
    private final int size;
    @NotNull
    private final Function1<Integer, T> generator;

    public VirtualBuffer(int size, @NotNull Function1<? super Integer, ? extends T> generator) {
        Intrinsics.checkNotNullParameter(generator, (String)"generator");
        this.size = size;
        this.generator = generator;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("Expected index from 0 to " + (this.getSize() - 1) + ", but found " + index);
        }
        return (T)this.generator.invoke((Object)index);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getSize()))), this.generator).iterator();
    }

    @Override
    @NotNull
    public String toString() {
        return Buffer.Companion.toString(this);
    }
}

