/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.real;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.UnstableKMathAPI;
import space.kscience.kmath.structures.Buffer;
import space.kscience.kmath.structures.DoubleBuffer;
import space.kscience.kmath.structures.DoubleBufferKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a(\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a#\u0010\f\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u0010\f\u001a\u00020\u0001H\u0087\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a(\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u0010\f\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\"\u001b\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"length", "", "Lkotlin/ranges/ClosedFloatingPointRange;", "getLength", "(Lkotlin/ranges/ClosedFloatingPointRange;)D", "fromRange", "Lspace/kscience/kmath/structures/DoubleBuffer;", "Lspace/kscience/kmath/structures/Buffer$Companion;", "range", "numberOfPoints", "", "(Lspace/kscience/kmath/structures/Buffer$Companion;Lkotlin/ranges/ClosedFloatingPointRange;I)[D", "step", "(Lkotlin/ranges/ClosedFloatingPointRange;D)[D", "withFixedStep", "(Lspace/kscience/kmath/structures/Buffer$Companion;Lkotlin/ranges/ClosedFloatingPointRange;D)[D", "kmath-for-real"})
@SourceDebugExtension(value={"SMAP\ngrids.kt\nKotlin\n*S Kotlin\n*F\n+ 1 grids.kt\nspace/kscience/kmath/real/GridsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DoubleBuffer.kt\nspace/kscience/kmath/structures/DoubleBufferKt\n*L\n1#1,54:1\n1#2:55\n45#3:56\n45#3:57\n45#3:58\n*S KotlinDebug\n*F\n+ 1 grids.kt\nspace/kscience/kmath/real/GridsKt\n*L\n24#1:56\n27#1:57\n42#1:58\n*E\n"})
public final class GridsKt {
    public static final double getLength(@NotNull ClosedFloatingPointRange<Double> $this$length) {
        Intrinsics.checkNotNullParameter($this$length, (String)"<this>");
        return ((Number)((Object)$this$length.getEndInclusive())).doubleValue() - ((Number)((Object)$this$length.getStart())).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] fromRange(@NotNull Buffer.Companion $this$fromRange, @NotNull ClosedFloatingPointRange<Double> range, int numberOfPoints) {
        ClosedFloatingPointRange closedFloatingPointRange;
        Intrinsics.checkNotNullParameter((Object)$this$fromRange, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        if (!(numberOfPoints >= 2)) {
            boolean $i$a$-require-GridsKt$fromRange$22 = false;
            String $i$a$-require-GridsKt$fromRange$22 = "Number of points in grid must be more than 1";
            throw new IllegalArgumentException($i$a$-require-GridsKt$fromRange$22.toString());
        }
        if (((Number)((Object)range.getEndInclusive())).doubleValue() > ((Number)((Object)range.getStart())).doubleValue()) {
            closedFloatingPointRange = range;
        } else if (((Number)((Object)range.getEndInclusive())).doubleValue() < ((Number)((Object)range.getStart())).doubleValue()) {
            closedFloatingPointRange = RangesKt.rangeTo((double)((Number)((Object)range.getEndInclusive())).doubleValue(), (double)((Number)((Object)range.getStart())).doubleValue());
        } else {
            boolean $i$f$DoubleBuffer = false;
            int n = 0;
            double[] dArray = new double[numberOfPoints];
            while (n < numberOfPoints) {
                double d;
                int n2;
                int n3 = n2 = n++;
                int n4 = n2;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n4] = d = ((Number)((Object)range.getStart())).doubleValue();
            }
            return DoubleBuffer.constructor-impl((double[])dArray);
        }
        ClosedFloatingPointRange normalizedRange = closedFloatingPointRange;
        double step = GridsKt.getLength(normalizedRange) / (double)(numberOfPoints - 1);
        boolean $i$f$DoubleBuffer = false;
        int n = 0;
        double[] dArray = new double[numberOfPoints];
        while (n < numberOfPoints) {
            void it;
            double d;
            int n5;
            int n6 = n5 = n++;
            int n7 = n5;
            double[] dArray3 = dArray;
            boolean bl = false;
            dArray3[n7] = d = ((Number)((Object)normalizedRange.getStart())).doubleValue() + step * (double)it;
        }
        return DoubleBuffer.constructor-impl((double[])dArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final double[] withFixedStep(@NotNull Buffer.Companion $this$withFixedStep, @NotNull ClosedFloatingPointRange<Double> range, double step) {
        ClosedFloatingPointRange closedFloatingPointRange;
        Intrinsics.checkNotNullParameter((Object)$this$withFixedStep, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        if (!(step > 0.0)) {
            boolean $i$a$-require-GridsKt$withFixedStep$22 = false;
            String $i$a$-require-GridsKt$withFixedStep$22 = "The grid step must be positive";
            throw new IllegalArgumentException($i$a$-require-GridsKt$withFixedStep$22.toString());
        }
        if (((Number)((Object)range.getEndInclusive())).doubleValue() > ((Number)((Object)range.getStart())).doubleValue()) {
            closedFloatingPointRange = range;
        } else if (((Number)((Object)range.getEndInclusive())).doubleValue() < ((Number)((Object)range.getStart())).doubleValue()) {
            closedFloatingPointRange = RangesKt.rangeTo((double)((Number)((Object)range.getEndInclusive())).doubleValue(), (double)((Number)((Object)range.getStart())).doubleValue());
        } else {
            double[] $i$a$-require-GridsKt$withFixedStep$22 = new double[]{((Number)((Object)range.getStart())).doubleValue()};
            return DoubleBufferKt.DoubleBuffer((double[])$i$a$-require-GridsKt$withFixedStep$22);
        }
        ClosedFloatingPointRange normalizedRange = closedFloatingPointRange;
        int numberOfPoints = (int)Math.floor(GridsKt.getLength(normalizedRange) / step) + 1;
        boolean $i$f$DoubleBuffer = false;
        int n = 0;
        double[] dArray = new double[numberOfPoints];
        while (n < numberOfPoints) {
            void it;
            double d;
            int n2;
            int n3 = n2 = n++;
            int n4 = n2;
            double[] dArray2 = dArray;
            boolean bl = false;
            dArray2[n4] = d = ((Number)((Object)normalizedRange.getStart())).doubleValue() + step * (double)it;
        }
        return DoubleBuffer.constructor-impl((double[])dArray);
    }

    @UnstableKMathAPI
    @NotNull
    public static final double[] step(@NotNull ClosedFloatingPointRange<Double> $this$step, double step) {
        Intrinsics.checkNotNullParameter($this$step, (String)"<this>");
        return GridsKt.withFixedStep(Buffer.Companion, $this$step, step);
    }
}

