/*
 * Decompiled with CFR 0.152.
 */
package space.kscience.kmath.memory;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import space.kscience.kmath.memory.Memory;
import space.kscience.kmath.memory.MemoryReader;
import space.kscience.kmath.memory.MemoryWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lspace/kscience/kmath/memory/ByteBufferMemory;", "Lspace/kscience/kmath/memory/Memory;", "buffer", "Ljava/nio/ByteBuffer;", "startOffset", "", "size", "(Ljava/nio/ByteBuffer;II)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "reader", "Lspace/kscience/kmath/memory/MemoryReader;", "getSize", "()I", "getStartOffset", "writer", "Lspace/kscience/kmath/memory/MemoryWriter;", "copy", "position", "offset", "view", "length", "kmath-memory"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nByteBufferMemory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBufferMemory.kt\nspace/kscience/kmath/memory/ByteBufferMemory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class ByteBufferMemory
implements Memory {
    @NotNull
    private final ByteBuffer buffer;
    private final int startOffset;
    private final int size;
    @NotNull
    private final MemoryReader reader;
    @NotNull
    private final MemoryWriter writer;

    public ByteBufferMemory(@NotNull ByteBuffer buffer, int startOffset, int size) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.startOffset = startOffset;
        this.size = size;
        this.reader = new MemoryReader(this){
            final /* synthetic */ ByteBufferMemory this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Memory getMemory() {
                return this.this$0;
            }

            public double readDouble(int offset) {
                return this.this$0.getBuffer().getDouble(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public float readFloat(int offset) {
                return this.this$0.getBuffer().getFloat(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public byte readByte(int offset) {
                return this.this$0.getBuffer().get(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public short readShort(int offset) {
                return this.this$0.getBuffer().getShort(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public int readInt(int offset) {
                return this.this$0.getBuffer().getInt(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public long readLong(int offset) {
                return this.this$0.getBuffer().getLong(ByteBufferMemory.access$position(this.this$0, offset));
            }

            public void close() {
            }
        };
        this.writer = new MemoryWriter(this){
            final /* synthetic */ ByteBufferMemory this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Memory getMemory() {
                return this.this$0;
            }

            public void writeDouble(int offset, double value) {
                this.this$0.getBuffer().putDouble(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void writeFloat(int offset, float value) {
                this.this$0.getBuffer().putFloat(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void writeByte(int offset, byte value) {
                this.this$0.getBuffer().put(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void writeShort(int offset, short value) {
                this.this$0.getBuffer().putShort(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void writeInt(int offset, int value) {
                this.this$0.getBuffer().putInt(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void writeLong(int offset, long value) {
                this.this$0.getBuffer().putLong(ByteBufferMemory.access$position(this.this$0, offset), value);
            }

            public void close() {
            }
        };
    }

    public /* synthetic */ ByteBufferMemory(ByteBuffer byteBuffer, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuffer.limit();
        }
        this(byteBuffer, n, n2);
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int position(int offset) {
        return this.startOffset + offset;
    }

    @Override
    @NotNull
    public Memory view(int offset, int length) {
        if (!(offset >= 0)) {
            boolean $i$a$-require-ByteBufferMemory$view$42 = false;
            String $i$a$-require-ByteBufferMemory$view$42 = "offset shouldn't be negative: " + offset;
            throw new IllegalArgumentException($i$a$-require-ByteBufferMemory$view$42.toString());
        }
        if (!(length >= 0)) {
            boolean $i$a$-require-ByteBufferMemory$view$52 = false;
            String $i$a$-require-ByteBufferMemory$view$52 = "length shouldn't be negative: " + length;
            throw new IllegalArgumentException($i$a$-require-ByteBufferMemory$view$52.toString());
        }
        if (!(offset + length <= this.getSize())) {
            boolean bl = false;
            String string = "Can't view memory outside the parent region.";
            throw new IllegalArgumentException(string.toString());
        }
        return new ByteBufferMemory(this.buffer, this.position(offset), length);
    }

    @Override
    @NotNull
    public Memory copy() {
        ByteBuffer copy = ByteBuffer.allocate(this.buffer.capacity());
        this.buffer.rewind();
        copy.put(this.buffer);
        copy.flip();
        Intrinsics.checkNotNullExpressionValue((Object)copy, (String)"copy");
        return new ByteBufferMemory(copy, 0, 0, 6, null);
    }

    @Override
    @NotNull
    public MemoryReader reader() {
        return this.reader;
    }

    @Override
    @NotNull
    public MemoryWriter writer() {
        return this.writer;
    }

    public static final /* synthetic */ int access$position(ByteBufferMemory $this, int offset) {
        return $this.position(offset);
    }
}

