/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectFunction;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Short2ObjectSyncMap;

final class Short2ObjectSyncMapImpl<V>
extends AbstractShort2ObjectMap<V>
implements Short2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final transient Object lock = new Object();
    private volatile transient Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>> read;
    private volatile transient boolean amended;
    private transient Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>> dirty;
    private transient int misses;
    private final transient IntFunction<Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>>> function;
    private transient EntrySetView entrySet;

    Short2ObjectSyncMapImpl(@NonNull IntFunction<Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>>> function, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promote();
        int size = 0;
        for (Short2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        this.promote();
        for (Short2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean containsValue(@Nullable Object value) {
        for (Short2ObjectMap.Entry entry : this.short2ObjectEntrySet()) {
            if (!Objects.equals(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(short key) {
        Short2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null && entry.exists();
    }

    public @Nullable V get(short key) {
        Short2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.get() : null;
    }

    public @NonNull V getOrDefault(short key, @NonNull V defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Short2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? entry.getOr(defaultValue) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Short2ObjectSyncMap.ExpungingEntry<V> getEntry(short key) {
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(short key, @NonNull IntFunction<? extends V> mappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfAbsent(key, mappingFunction) : null;
        if (result != null && result.operation() == 1) {
            return result.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndCompute(key, mappingFunction)) {
                    if (entry.exists()) {
                        this.dirty.put(key, (Object)entry);
                    }
                    return entry.get();
                }
                result = entry.computeIfAbsent(key, mappingFunction);
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result = entry.computeIfAbsent(key, mappingFunction);
                if (result.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                V computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = mappingFunction.apply(key)) != null) {
                    this.dirty.put(key, new ExpungingEntryImpl<V>(computed));
                }
                return computed;
            }
        }
        return result.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(short key, @NonNull Short2ObjectFunction<? extends V> mappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfAbsentPrimitive(key, mappingFunction) : null;
        if (result != null && result.operation() == 1) {
            return result.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndComputePrimitive(key, mappingFunction)) {
                    if (entry.exists()) {
                        this.dirty.put(key, (Object)entry);
                    }
                    return entry.get();
                }
                result = entry.computeIfAbsentPrimitive(key, mappingFunction);
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result = entry.computeIfAbsentPrimitive(key, mappingFunction);
                if (result.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                Object computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = mappingFunction.get(key)) != null) {
                    this.dirty.put(key, new ExpungingEntryImpl<Object>(computed));
                }
                return (V)computed;
            }
        }
        return result.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfPresent(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfPresent(key, remappingFunction) : null;
        if (result != null && result.operation() == 1) {
            return result.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                result = entry.computeIfPresent(key, remappingFunction);
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result = entry.computeIfPresent(key, remappingFunction);
                if (result.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            }
        }
        return result != null ? (V)result.current() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V compute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.compute(key, remappingFunction) : null;
        if (result != null && result.operation() == 1) {
            return result.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndCompute(key, remappingFunction)) {
                    if (entry.exists()) {
                        this.dirty.put(key, (Object)entry);
                    }
                    return entry.get();
                }
                result = entry.compute(key, remappingFunction);
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result = entry.compute(key, remappingFunction);
                if (result.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                V computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = remappingFunction.apply(key, null)) != null) {
                    this.dirty.put(key, new ExpungingEntryImpl<V>(computed));
                }
                return computed;
            }
        }
        return result.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V putIfAbsent(short key, @NonNull V value) {
        Short2ObjectSyncMap.InsertionResult<V> result;
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.setIfAbsent(value) : null;
        if (result != null && result.operation() == 1) {
            return result.previous();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                    return null;
                }
                result = entry.setIfAbsent(value);
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result = entry.setIfAbsent(value);
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, new ExpungingEntryImpl<V>(value));
                return null;
            }
        }
        return result.previous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V put(short key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else if (this.dirty != null && (entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                previous = entry.get();
                entry.set(value);
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, new ExpungingEntryImpl<V>(value));
                return null;
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V remove(short key) {
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(short key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    boolean present;
                    entry = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    boolean bl = present = entry != null && entry.replace(value, null);
                    if (present) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                    return present;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    public @Nullable V replace(short key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.tryReplace(value) : null;
    }

    public boolean replace(short key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Short2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null && entry.replace(oldValue, newValue);
    }

    public void forEach(@NonNull BiConsumer<? super Short, ? super V> action) {
        Objects.requireNonNull(action, "action");
        this.promote();
        for (Short2ObjectMap.Entry that : this.read.short2ObjectEntrySet()) {
            Object value = ((Short2ObjectSyncMap.ExpungingEntry)that.getValue()).get();
            if (value == null) continue;
            action.accept(that.getShortKey(), value);
        }
    }

    public void putAll(@NonNull Map<? extends Short, ? extends V> map) {
        Objects.requireNonNull(map, "map");
        for (Map.Entry<Short, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void replaceAll(@NonNull BiFunction<? super Short, ? super V, ? extends V> function) {
        Objects.requireNonNull(function, "function");
        this.promote();
        for (Short2ObjectMap.Entry that : this.read.short2ObjectEntrySet()) {
            Short2ObjectSyncMap.ExpungingEntry entry = (Short2ObjectSyncMap.ExpungingEntry)that.getValue();
            Object value = entry.get();
            if (value == null) continue;
            entry.tryReplace(function.apply(that.getShortKey(), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.dirty = null;
            this.amended = false;
            this.misses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Short2ObjectMap.Entry<V>> short2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySetView();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promote() {
        if (this.amended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.amended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void missLocked() {
        ++this.misses;
        if (this.misses < this.dirty.size()) {
            return;
        }
        this.promoteLocked();
    }

    private void promoteLocked() {
        this.read = this.dirty;
        this.amended = false;
        this.dirty = null;
        this.misses = 0;
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Short2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Short2ObjectSyncMap.ExpungingEntry)entry.getValue()).tryExpunge()) {
                this.dirty.put(entry.getShortKey(), (Object)((Short2ObjectSyncMap.ExpungingEntry)entry.getValue()));
            }
        });
    }

    final class EntryIterator
    implements ObjectIterator<Short2ObjectMap.Entry<V>> {
        private final Iterator<Short2ObjectMap.Entry<Short2ObjectSyncMap.ExpungingEntry<V>>> backingIterator;
        private Short2ObjectMap.Entry<V> next;
        private Short2ObjectMap.Entry<V> current;

        EntryIterator(Iterator<Short2ObjectMap.Entry<Short2ObjectSyncMap.ExpungingEntry<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            this.advance();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Short2ObjectMap.Entry<V> next() {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull Short2ObjectMap.Entry<V> current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.current = current;
            this.advance();
            return current;
        }

        public void remove() {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull Short2ObjectMap.Entry<V> current = this.current;
            if (current == null) {
                throw new IllegalStateException();
            }
            this.current = null;
            Short2ObjectSyncMapImpl.this.remove(current.getShortKey());
        }

        private void advance() {
            this.next = null;
            while (this.backingIterator.hasNext()) {
                Short2ObjectMap.Entry entry = this.backingIterator.next();
                Object value = ((Short2ObjectSyncMap.ExpungingEntry)entry.getValue()).get();
                if (value == null) continue;
                this.next = new MapEntry(entry.getShortKey(), value);
                return;
            }
        }
    }

    final class EntrySetView
    extends AbstractObjectSet<Short2ObjectMap.Entry<V>> {
        EntrySetView() {
        }

        public int size() {
            return Short2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry mapEntry = (Short2ObjectMap.Entry)entry;
            Object value = Short2ObjectSyncMapImpl.this.get(mapEntry.getShortKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean add(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Short2ObjectMap.Entry<V> entry) {
            Objects.requireNonNull(entry, "entry");
            return Short2ObjectSyncMapImpl.this.put(entry.getShortKey(), entry.getValue()) == null;
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry mapEntry = (Short2ObjectMap.Entry)entry;
            return Short2ObjectSyncMapImpl.this.remove(mapEntry.getShortKey(), mapEntry.getValue());
        }

        public void clear() {
            Short2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Short2ObjectMap.Entry<V>> iterator() {
            Short2ObjectSyncMapImpl.this.promote();
            return new EntryIterator(Short2ObjectSyncMapImpl.this.read.short2ObjectEntrySet().iterator());
        }
    }

    final class MapEntry
    implements Short2ObjectMap.Entry<V> {
        private final short key;
        private V value;

        MapEntry(@NonNull short key, V value) {
            this.key = key;
            this.value = value;
        }

        public short getShortKey() {
            return this.key;
        }

        public @NonNull V getValue() {
            return this.value;
        }

        public @Nullable V setValue(@NonNull V value) {
            Objects.requireNonNull(value, "value");
            Object previous = Short2ObjectSyncMapImpl.this.put(this.key, value);
            this.value = value;
            return previous;
        }

        public @NonNull String toString() {
            return "Short2ObjectSyncMapImpl.MapEntry{key=" + this.getShortKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry that = (Short2ObjectMap.Entry)other;
            return Objects.equals(this.getShortKey(), that.getShortKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getShortKey(), this.getValue());
        }
    }

    static final class InsertionResultImpl<V>
    implements Short2ObjectSyncMap.InsertionResult<V> {
        private static final byte UNCHANGED = 0;
        private static final byte UPDATED = 1;
        private static final byte EXPUNGED = 2;
        private final byte operation;
        private final V previous;
        private final V current;

        InsertionResultImpl(byte operation, @Nullable V previous, @Nullable V current) {
            this.operation = operation;
            this.previous = previous;
            this.current = current;
        }

        @Override
        public byte operation() {
            return this.operation;
        }

        @Override
        public @Nullable V previous() {
            return this.previous;
        }

        @Override
        public @Nullable V current() {
            return this.current;
        }
    }

    static final class ExpungingEntryImpl<V>
    implements Short2ObjectSyncMap.ExpungingEntry<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingEntryImpl, Object> UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingEntryImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        ExpungingEntryImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public boolean exists() {
            return this.value != null && this.value != EXPUNGED;
        }

        @Override
        public @Nullable V get() {
            return (V)(this.value == EXPUNGED ? null : this.value);
        }

        @Override
        public @NonNull V getOr(@NonNull V other) {
            Object value = this.value;
            return (V)(value != null && value != EXPUNGED ? this.value : other);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> setIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, value));
            return new InsertionResultImpl<Object>(1, null, value);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfAbsent(short key, @NonNull IntFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = (Object)function.apply(key))));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfAbsentPrimitive(short key, @NonNull Short2ObjectFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = function.containsKey(key) ? function.get(key) : null)));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfPresent(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous != null) continue;
                return new InsertionResultImpl<Object>(0, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(key, previous))));
            return new InsertionResultImpl<Object>(1, previous, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> compute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return new InsertionResultImpl<Object>(2, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(key, previous))));
            return new InsertionResultImpl<Object>(1, previous, next);
        }

        @Override
        public void set(@NonNull V value) {
            UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED && Objects.equals(previous, compare)) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, null));
            return (V)previous;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V tryReplace(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return (V)previous;
        }

        @Override
        public boolean tryExpunge() {
            while (this.value == null) {
                if (!UPDATER.compareAndSet(this, null, EXPUNGED)) continue;
                return true;
            }
            return this.value == EXPUNGED;
        }

        @Override
        public boolean tryUnexpungeAndSet(@NonNull V value) {
            return UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        @Override
        public boolean tryUnexpungeAndCompute(short key, @NonNull IntFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                V value = function.apply(key);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndComputePrimitive(short key, @NonNull Short2ObjectFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                Object value = function.containsKey(key) ? function.get(key) : null;
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndCompute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            if (this.value == EXPUNGED) {
                V value = remappingFunction.apply(key, null);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }
    }
}

