package space.yizhu.kits;/* Created by yi on 12/3/2020.*/

/**
 * <p>AddressKit class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class AddressKit {
    /**
     * <p>isIpInRange.</p>
     *
     * @param start a {@link java.lang.String} object.
     * @param end a {@link java.lang.String} object.
     * @param real a {@link java.lang.String} object.
     * @return a boolean.
     */
    public static boolean isIpInRange(String start, String end, String real) {
        if (null==start||null==end||null==real){
            return false;
        }
        try {
            String[] stIpNums = start.split("\\.");
            String[] edIpNums = end.split("\\.");
            String[] ipNums = real.split("\\.");
            if (stIpNums.length != edIpNums.length||stIpNums.length != ipNums.length) {
                return false;
            }
            int forwordNums = 0,backNums=0;
            int s,e,r;
            for (int i = 0; i < stIpNums.length; i++) {
                r = Integer.parseInt(ipNums[i]);
                s = Integer.parseInt(stIpNums[i]);
                e = Integer.parseInt(edIpNums[i]);
                if (s>0) {

                    if (r<s||r>e) {
                        if (forwordNums==0){
                            return false;
                        }
                    }
                }else {
                    if (e>0){
                        if (r>e&&forwordNums==0) {
                            return false;
                        }
                    }
                }
                forwordNums += e > s ? 1 : 0;
            }
            return true;
        } catch (NumberFormatException e) {
            SysKit.print(e,"isIpInRange");
            return false;

        }
    }

    /**
     * 判断实际ip是否在预存的ip段中
     *
     * @param large 预存的IP段
     * @param small 要对比的实际ip
     * @return bool
     */
    public static boolean isSameIp(String large, String small) {
        if (large.equals(small)) {
            return true;
        } else {
            String[] larges = large.split("\\.");
            String[] smalls = small.split("\\.");
            if (larges.length != smalls.length) {
                return false;
            }
            for (int i = 0; i < larges.length; i++) {
                if (!larges[i].equals("0")) {
                    if (larges[i].equals(smalls[i])) {
                        continue;
                    }
                } else {
                    continue;
                }
                return false;
            }
            return true;

        }
    }
    /** Constant <code>pi=3.1415926535897932384626</code> */
    public static double pi = 3.1415926535897932384626;
    /** Constant <code>x_pi=3.14159265358979324 * 3000.0 / 180.0</code> */
    public static double x_pi = 3.14159265358979324 * 3000.0 / 180.0;
    /** Constant <code>a=6378245.0</code> */
    public static double a = 6378245.0;
    /** Constant <code>ee=0.00669342162296594323</code> */
    public static double ee = 0.00669342162296594323;

    /**
     * <p>transformLat.</p>
     *
     * @param x a double.
     * @param y a double.
     * @return a double.
     */
    public static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
        ret += (160.0 * Math.sin(y / 12.0 * pi) + 320 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
        return ret;
    }

    /**
     * <p>transformLon.</p>
     *
     * @param x a double.
     * @param y a double.
     * @return a double.
     */
    public static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * pi) + 40.0 * Math.sin(x / 3.0 * pi)) * 2.0 / 3.0;
        ret += (150.0 * Math.sin(x / 12.0 * pi) + 300.0 * Math.sin(x / 30.0 * pi)) * 2.0 / 3.0;
        return ret;
    }
    /**
     * <p>transform.</p>
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] transform(double lat, double lon) {
        if (outOfChina(lat, lon)) {
            return new double[]{lat,lon};
        }
        double dLat = transformLat(lon - 105.0, lat - 35.0);
        double dLon = transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = (dLat * 180.0) / ((a * (1 - ee)) / (magic * sqrtMagic) * pi);
        dLon = (dLon * 180.0) / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat,mgLon};
    }
    /**
     * 判断是否在中国
     *
     * @param lat a double.
     * @param lon a double.
     * @return a boolean.
     */
    public static boolean outOfChina(double lat, double lon) {
        if (lon < 72.004 || lon > 137.8347)
            return true;
        if (lat < 0.8293 || lat > 55.8271)
            return true;
        return false;
    }
    /**
     * 84 ==》 高德
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] gps84_To_Gcj02(double lat, double lon) {
        if (outOfChina(lat, lon)) {
            return new double[]{lat,lon};
        }
        double dLat = transformLat(lon - 105.0, lat - 35.0);
        double dLon = transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = (dLat * 180.0) / ((a * (1 - ee)) / (magic * sqrtMagic) * pi);
        dLon = (dLon * 180.0) / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new double[]{mgLat, mgLon};
    }

    /**
     * 高德 ==》 84
     *
     * @param lon * @param lat * @return
     * @param lat a double.
     * @return an array of {@link double} objects.
     */
    public static double[] gcj02_To_Gps84(double lat, double lon) {
        double[] gps = transform(lat, lon);
        double lontitude = lon * 2 - gps[1];
        double latitude = lat * 2 - gps[0];
        return new double[]{latitude, lontitude};
    }
    /**
     * 高德 == 》 百度
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] gcj02_To_Bd09(double lat, double lon) {
        double x = lon, y = lat;
        double z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * x_pi);
        double tempLon = z * Math.cos(theta) + 0.0065;
        double tempLat = z * Math.sin(theta) + 0.006;
        double[] gps = {tempLat,tempLon};
        return gps;
    }

    /**
     * 百度 == 》 高德
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] bd09_To_Gcj02(double lat, double lon) {
        double x = lon - 0.0065, y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * x_pi);
        double tempLon = z * Math.cos(theta);
        double tempLat = z * Math.sin(theta);
        double[] gps = {tempLat,tempLon};
        return gps;
    }

    /**
     * 84 == 》 百度
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] gps84_To_bd09(double lat,double lon){
        double[] gcj02 = gps84_To_Gcj02(lat,lon);
        double[] bd09 = gcj02_To_Bd09(gcj02[0],gcj02[1]);
        return bd09;
    }

    /**
     * 百度 == 》 84
     *
     * @param lat a double.
     * @param lon a double.
     * @return an array of {@link double} objects.
     */
    public static double[] bd09_To_gps84(double lat,double lon){
        double[] gcj02 = bd09_To_Gcj02(lat, lon);
        double[] gps84 = gcj02_To_Gps84(gcj02[0], gcj02[1]);
        //保留小数点后六位
        gps84[0] = retain6(gps84[0]);
        gps84[1] = retain6(gps84[1]);
        return gps84;
    }

    /*
     * 保留小数点后六位
     * @param num
     * @return
     */
    private static double retain6(double num){
        String result = String .format("%.6f", num);
        return Double.valueOf(result);
    }


    /**
     * <p>main.</p>
     *
     * @param args an array of {@link java.lang.String} objects.
     */
    public static void main(String[] args) {
        SysKit.print(isIpInRange("0.1.7.0", "0.161.0.1", "192.166.1.2")+"");
        SysKit.print(isSameIp("192.0.1.0",  "192.168.1.1")+"");
    }
}
