package space.yizhu.kits;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.util.Arrays;

/**
 * 兼容微信所使用的AES加密方式。
 * aes的key必须是256byte长（如32个字符）
 *
 * @author yi
 * @version $Id: $Id
 */
public class AesKit {

    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private AesKit() {
    }

    /**
     * <p>getAesKey.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public static String getAesKey() {
        return HashKit.generateSalt(32);
    }

    /**
     * <p>encrypt.</p>
     *
     * @param content an array of {@link byte} objects.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return an array of {@link byte} objects.
     */
    public static byte[] encrypt(byte[] content, String aesTextKey) {
        return encrypt(content, aesTextKey.getBytes(UTF_8));
    }

    /**
     * <p>encrypt.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String encrypt(String content, String aesTextKey) {
        return Base64Kit.encode(encrypt(content.getBytes(UTF_8), aesTextKey.getBytes(UTF_8)));
    }
    /**
     * <p>decrypt.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String decrypt(String content, String aesTextKey) {
        return  new String(decrypt(Base64Kit.decode(content), aesTextKey.getBytes(UTF_8)));
    }

    /**
     * <p>encrypt.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param charsetName a {@link java.lang.String} object.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return an array of {@link byte} objects.
     */
    public static byte[] encrypt(String content, String charsetName, String aesTextKey) {
        return encrypt(content.getBytes(Charset.forName(charsetName)), aesTextKey.getBytes(UTF_8));
    }

    /**
     * <p>decrypt.</p>
     *
     * @param content an array of {@link byte} objects.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return an array of {@link byte} objects.
     */
    public static byte[] decrypt(byte[] content, String aesTextKey) {
        return decrypt(content, aesTextKey.getBytes(UTF_8));
    }

    /**
     * <p>decryptToStr.</p>
     *
     * @param content an array of {@link byte} objects.
     * @param aesTextKey a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String decryptToStr(byte[] content, String aesTextKey) {
        return new String(decrypt(content, aesTextKey.getBytes(UTF_8)), UTF_8);
    }

    /**
     * <p>decryptToStr.</p>
     *
     * @param content an array of {@link byte} objects.
     * @param aesTextKey a {@link java.lang.String} object.
     * @param charsetName a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String decryptToStr(byte[] content, String aesTextKey, String charsetName) {
        return new String(decrypt(content, aesTextKey.getBytes(UTF_8)), Charset.forName(charsetName));
    }

    /**
     * <p>encrypt.</p>
     *
     * @param content an array of {@link byte} objects.
     * @param aesKey an array of {@link byte} objects.
     * @return an array of {@link byte} objects.
     */
    public static byte[] encrypt(byte[] content, byte[] aesKey) {
        try {
            if (aesKey.length != 32) {
                throw new RuntimeException("IllegalAesKey, aesKey's length must be 32");
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, iv);
//            return cipher.doFinal(PKCS7Encoder.encode());
            return cipher.doFinal(PKCS7Encoder.encode(content));
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * <p>decrypt.</p>
     *
     * @param encrypted an array of {@link byte} objects.
     * @param aesKey an array of {@link byte} objects.
     * @return an array of {@link byte} objects.
     */
    public static byte[] decrypt(byte[] encrypted, byte[] aesKey) {
        try {
            if (aesKey.length != 32) {
                throw new RuntimeException("IllegalAesKey, aesKey's length must be 32");
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(Cipher.DECRYPT_MODE, key_spec, iv);
            return PKCS7Encoder.decode(cipher.doFinal(encrypted));
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * 提供基于PKCS7算法的加解密接口.
     */
    static class PKCS7Encoder {
        static int BLOCK_SIZE = 32;

        static byte[] encode(byte[] src) {
            int count = src.length;
            // 计算需要填充的位数
            int amountToPad = BLOCK_SIZE - (count % BLOCK_SIZE);
            if (amountToPad == 0) {
                amountToPad = BLOCK_SIZE;
            }
            // 获得补位所用的字符
            byte pad = (byte) (amountToPad & 0xFF);
            byte[] pads = new byte[amountToPad];
            for (int index = 0; index < amountToPad; index++) {
                pads[index] = pad;
            }
            int length = count + amountToPad;
            byte[] dest = new byte[length];
            System.arraycopy(src, 0, dest, 0, count);
            System.arraycopy(pads, 0, dest, count, amountToPad);
            return dest;
        }

        static byte[] decode(byte[] decrypted) {
            int pad = (int) decrypted[decrypted.length - 1];
            if (pad < 1 || pad > 32) {
                pad = 0;
            }
            if (pad > 0) {
                return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
            }
            return decrypted;
        }
    }

    /**
     * <p>main.</p>
     *
     * @param args an array of {@link java.lang.String} objects.
     */
    public static void main(String[] args) {
        String pw = "测试";
        String pwhast="测试";
        String salt=ToolKit.toMd5("张三");
        SysKit.print(pwhast);
        SysKit.print(salt);
        String ret = encrypt(pwhast, salt);
      SysKit.print(ret);  ;
      SysKit.print(decrypt(ret, salt));  ;
    }
}
