

package space.yizhu.kits;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;

import space.yizhu.record.core.Const;

/**
 * FitKit. FitKit can load properties file from CLASSPATH or File object.
 *
 * @author yi
 * @version $Id: $Id
 */
public class FitKit {

    private static ConfigFile configFile = null;
    private static final ConcurrentHashMap<String, ConfigFile> map = new ConcurrentHashMap<String, ConfigFile>();

    private FitKit() {
    }

    /**
     * Using the properties file. It will loading the properties file if not loading.
     *
     * @see #use(String, String)
     * @param fileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile use(String fileName) {
        return use(fileName, Const.DEFAULT_ENCODING);
    }

    /**
     * Using the properties file. It will loading the properties file if not loading.
     * <p>
     * Example:<br>
     * FitKit.use("config.txt", "UTF-8");<br>
     * FitKit.use("other_config.txt", "UTF-8");<br><br>
     * String userName = FitKit.get("userName");<br>
     * String password = FitKit.get("password");<br><br>
     *
     * userName = FitKit.use("other_config.txt").get("userName");<br>
     * password = FitKit.use("other_config.txt").get("password");<br><br>
     *
     * FitKit.use("config_in_sub_directory_of_classpath.txt");
     *
     * @param fileName the properties file's name in classpath or the sub directory of classpath
     * @param encoding the encoding
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile use(String fileName, String encoding) {
        ConfigFile result = map.get(fileName);
        if (result == null) {
            synchronized (FitKit.class) {
                result = map.get(fileName);
                if (result == null) {
                    result = new ConfigFile(fileName, encoding);
                    map.put(fileName, result);
                    if (FitKit.configFile == null) {
                        FitKit.configFile = result;
                    }
                }
            }
        }
        return result;
    }

    /**
     * Using the properties file bye File object. It will loading the properties file if not loading.
     *
     * @see #use(File, String)
     * @param file a {@link java.io.File} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile use(File file) {
        return use(file, Const.DEFAULT_ENCODING);
    }

    /**
     * Using the properties file bye File object. It will loading the properties file if not loading.
     * <p>
     * Example:<br>
     * FitKit.use(new File("/var/config/my_config.txt"), "UTF-8");<br>
     * Strig userName = FitKit.use("my_config.txt").get("userName");
     *
     * @param file the properties File object
     * @param encoding the encoding
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile use(File file, String encoding) {
        ConfigFile result = map.get(file.getName());
        if (result == null) {
            synchronized (FitKit.class) {
                result = map.get(file.getName());
                if (result == null) {
                    result = new ConfigFile(file, encoding);
                    map.put(file.getName(), result);
                    if (FitKit.configFile == null) {
                        FitKit.configFile = result;
                    }
                }
            }
        }
        return result;
    }

    /**
     * <p>useless.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile useless(String fileName) {
        ConfigFile previous = map.remove(fileName);
        if (FitKit.configFile == previous) {
            FitKit.configFile = null;
        }
        return previous;
    }

    /**
     * <p>clear.</p>
     */
    public static void clear() {
        configFile = null;
        map.clear();
    }

    /**
     * <p>append.</p>
     *
     * @param configFile a {@link space.yizhu.kits.ConfigFile} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile append(ConfigFile configFile) {
        synchronized (FitKit.class) {
            if (FitKit.configFile != null) {
                FitKit.configFile.append(configFile);
            } else {
                FitKit.configFile = configFile;
            }
            return FitKit.configFile;
        }
    }

    /**
     * <p>append.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @param encoding a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile append(String fileName, String encoding) {
        return append(new ConfigFile(fileName, encoding));
    }

    /**
     * <p>append.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile append(String fileName) {
        return append(fileName, Const.DEFAULT_ENCODING);
    }

    /**
     * <p>appendIfExists.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @param encoding a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile appendIfExists(String fileName, String encoding) {
        try {
            return append(new ConfigFile(fileName, encoding));
        } catch (Exception e) {
            return FitKit.configFile;
        }
    }

    /**
     * <p>appendIfExists.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile appendIfExists(String fileName) {
        return appendIfExists(fileName, Const.DEFAULT_ENCODING);
    }

    /**
     * <p>append.</p>
     *
     * @param file a {@link java.io.File} object.
     * @param encoding a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile append(File file, String encoding) {
        return append(new ConfigFile(file, encoding));
    }

    /**
     * <p>append.</p>
     *
     * @param file a {@link java.io.File} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile append(File file) {
        return append(file, Const.DEFAULT_ENCODING);
    }

    /**
     * <p>appendIfExists.</p>
     *
     * @param file a {@link java.io.File} object.
     * @param encoding a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile appendIfExists(File file, String encoding) {
        if (file.exists()) {
            append(new ConfigFile(file, encoding));
        }
        return FitKit.configFile;
    }

    /**
     * <p>appendIfExists.</p>
     *
     * @param file a {@link java.io.File} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile appendIfExists(File file) {
        return appendIfExists(file, Const.DEFAULT_ENCODING);
    }

    /**
     * <p>Getter for the field <code>configFile</code>.</p>
     *
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile getConfigFile() {
        if (configFile == null) {
            throw new IllegalStateException("Load propties file by invoking FitKit.use(String fileName) method first.");
        }
        return configFile;
    }

    /**
     * <p>getProp.</p>
     *
     * @param fileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile getProp(String fileName) {
        return map.get(fileName);
    }

    /**
     * <p>get.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String get(String key) {
        return getConfigFile().get(key);
    }
    /**
     * <p>getObj.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.Object} object.
     */
    public static Object getObj(String key) {
        return getConfigFile().getObj(key);
    }

    /**
     * <p>get.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String get(String key, String defaultValue) {
        return getConfigFile().get(key, defaultValue);
    }

    /**
     * <p>getInt.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.Integer} object.
     */
    public static Integer getInt(String key) {
        return getConfigFile().getInt(key);
    }

    /**
     * <p>getInt.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.Integer} object.
     * @return a {@link java.lang.Integer} object.
     */
    public static Integer getInt(String key, Integer defaultValue) {
        return getConfigFile().getInt(key, defaultValue);
    }

    /**
     * <p>getLong.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.Long} object.
     */
    public static Long getLong(String key) {
        return getConfigFile().getLong(key);
    }

    /**
     * <p>getLong.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.Long} object.
     * @return a {@link java.lang.Long} object.
     */
    public static Long getLong(String key, Long defaultValue) {
        return getConfigFile().getLong(key, defaultValue);
    }

    /**
     * <p>getBoolean.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public static Boolean getBoolean(String key) {
        return getConfigFile().getBoolean(key);
    }

    /**
     * <p>getBoolean.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.Boolean} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return getConfigFile().getBoolean(key, defaultValue);
    }

    /**
     * <p>containsKey.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a boolean.
     */
    public static boolean containsKey(String key) {
        return getConfigFile().containsKey(key);
    }


    /**
     * <p>main.</p>
     *
     * @param args an array of {@link java.lang.String} objects.
     */
    public static void main(String[] args) {
        FitKit.use("app.yml").getInt("server.port");
        FitKit.getObj("test.port");
    }
}


