

package space.yizhu.kits;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * JavaKeyword.
 *
 * @author yi
 * @version $Id: $Id
 */
public class JavaKeyword {

    private String[] keywordArray = {
            "abstract",
            "assert",
            "boolean",
            "break",
            "byte",
            "case",
            "catch",
            "char",
            "class",
            "const",
            "continue",
            "default",
            "do",
            "double",
            "else",
            "enum",
            "extends",
            "final",
            "finally",
            "float",
            "for",
            "goto",
            "if",
            "implements",
            "import",
            "instanceof",
            "int",
            "interface",
            "long",
            "native",
            "new",
            "package",
            "private",
            "protected",
            "public",
            "return",
            "strictfp",
            "short",
            "static",
            "super",
            "switch",
            "synchronized",
            "this",
            "throw",
            "throws",
            "transient",
            "try",
            "void",
            "volatile",
            "while"
    };

    private Set<String> set;

    /** Constant <code>me</code> */
    public static final JavaKeyword me = createSharedInstance();

    private static JavaKeyword createSharedInstance() {
        JavaKeyword jk = new JavaKeyword();
        jk.set = Collections.unmodifiableSet(jk.set);    // 共享对象不让修改
        return jk;
    }

    /**
     * <p>Constructor for JavaKeyword.</p>
     */
    public JavaKeyword() {
        set = new HashSet<String>();
        for (String keyword : keywordArray) {
            set.add(keyword);
        }
    }

    /**
     * <p>addKeyword.</p>
     *
     * @param keyword a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.JavaKeyword} object.
     */
    public JavaKeyword addKeyword(String keyword) {
        if (StrKit.notBlank(keyword)) {
            set.add(keyword);
        }
        return this;
    }

    /**
     * <p>removeKeyword.</p>
     *
     * @param keyword a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.JavaKeyword} object.
     */
    public JavaKeyword removeKeyword(String keyword) {
        set.remove(keyword);
        return this;
    }

    /**
     * <p>contains.</p>
     *
     * @param str a {@link java.lang.String} object.
     * @return a boolean.
     */
    public boolean contains(String str) {
        return set.contains(str);
    }
}






