

package space.yizhu.kits;

import com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

/**
 * Kv (Key Value)
 *
 * Example：
 *    Kv para = Kv.by("id", 123);
 *    User user = user.findFirst(getSqlPara("find", para));
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings({"serial", "rawtypes", "unchecked"})
public class Kv extends HashMap {

    @Deprecated
    private static final String STATE_OK = "isOk";
    @Deprecated
    private static final String STATE_FAIL = "isFail";

    /**
     * <p>Constructor for Kv.</p>
     */
    public Kv() {
    }

    /**
     * <p>by.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public static Kv by(Object key, Object value) {
        return new Kv().set(key, value);
    }

    /**
     * <p>create.</p>
     *
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public static Kv create() {
        return new Kv();
    }

    /**
     * <p>ok.</p>
     *
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public static Kv ok() {
        return new Kv().setOk();
    }

    /**
     * <p>ok.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public static Kv ok(Object key, Object value) {
        return ok().set(key, value);
    }

    /**
     * <p>fail.</p>
     *
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public static Kv fail() {
        return new Kv().setFail();
    }

    /**
     * <p>fail.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public static Kv fail(Object key, Object value) {
        return fail().set(key, value);
    }

    /**
     * <p>setOk.</p>
     *
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public Kv setOk() {
        super.put(STATE_OK, Boolean.TRUE);
        super.put(STATE_FAIL, Boolean.FALSE);
        return this;
    }

    /**
     * <p>setFail.</p>
     *
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    @Deprecated
    public Kv setFail() {
        super.put(STATE_FAIL, Boolean.TRUE);
        super.put(STATE_OK, Boolean.FALSE);
        return this;
    }

    /**
     * <p>isOk.</p>
     *
     * @return a boolean.
     */
    @Deprecated
    public boolean isOk() {
        Boolean isOk = (Boolean) get(STATE_OK);
        if (isOk != null) {
            return isOk;
        }
        Boolean isFail = (Boolean) get(STATE_FAIL);
        if (isFail != null) {
            return !isFail;
        }

        throw new IllegalStateException("调用 isOk() 之前，必须先调用 ok()、fail() 或者 setOk()、setFail() 方法");
    }

    /**
     * <p>isFail.</p>
     *
     * @return a boolean.
     */
    @Deprecated
    public boolean isFail() {
        Boolean isFail = (Boolean) get(STATE_FAIL);
        if (isFail != null) {
            return isFail;
        }
        Boolean isOk = (Boolean) get(STATE_OK);
        if (isOk != null) {
            return !isOk;
        }

        throw new IllegalStateException("调用 isFail() 之前，必须先调用 ok()、fail() 或者 setOk()、setFail() 方法");
    }

    /**
     * <p>set.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv set(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    /**
     * <p>setIfNotBlank.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv setIfNotBlank(Object key, String value) {
        if (StrKit.notBlank(value)) {
            set(key, value);
        }
        return this;
    }

    /**
     * <p>setIfNotNull.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv setIfNotNull(Object key, Object value) {
        if (value != null) {
            set(key, value);
        }
        return this;
    }

    /**
     * <p>set.</p>
     *
     * @param map a {@link java.util.Map} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv set(Map map) {
        super.putAll(map);
        return this;
    }

    /**
     * <p>set.</p>
     *
     * @param kv a {@link space.yizhu.kits.Kv} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv set(Kv kv) {
        super.putAll(kv);
        return this;
    }

    /**
     * <p>delete.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.kits.Kv} object.
     */
    public Kv delete(Object key) {
        super.remove(key);
        return this;
    }

    /**
     * <p>getAs.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public <T> T getAs(Object key) {
        return (T) get(key);
    }

    /**
     * <p>getStr.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.String} object.
     */
    public String getStr(Object key) {
        Object s = get(key);
        return s != null ? s.toString() : null;
    }

    /**
     * <p>getInt.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getInt(Object key) {
        Number n = (Number) get(key);
        return n != null ? n.intValue() : null;
    }

    /**
     * <p>getLong.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Long} object.
     */
    public Long getLong(Object key) {
        Number n = (Number) get(key);
        return n != null ? n.longValue() : null;
    }

    /**
     * <p>getNumber.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Number} object.
     */
    public Number getNumber(Object key) {
        return (Number) get(key);
    }

    /**
     * <p>getBoolean.</p>
     *
     * @param key a {@link java.lang.Object} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public Boolean getBoolean(Object key) {
        return (Boolean) get(key);
    }

    /**
     * key 存在，并且 value 不为 null
     *
     * @param key a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public boolean notNull(Object key) {
        return get(key) != null;
    }

    /**
     * key 不存在，或者 key 存在但 value 为null
     *
     * @param key a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public boolean isNull(Object key) {
        return get(key) == null;
    }

    /**
     * key 存在，并且 value 为 true，则返回 true
     *
     * @param key a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public boolean isTrue(Object key) {
        Object value = get(key);
        return (value instanceof Boolean && ((Boolean) value == true));
    }

    /**
     * key 存在，并且 value 为 false，则返回 true
     *
     * @param key a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public boolean isFalse(Object key) {
        Object value = get(key);
        return (value instanceof Boolean && ((Boolean) value == false));
    }

    /**
     * <p>toJson.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toJson() {
        return new Gson().toJson(this);
    }

    /** {@inheritDoc} */
    public boolean equals(Object kv) {
        return kv instanceof Kv && super.equals(kv);
    }
}


