

package space.yizhu.kits;

import space.yizhu.bean.LogModel;
import space.yizhu.record.log.Log;
import space.yizhu.record.plugin.activerecord.Model;

/**
 * LogKit.
 *
 * @author yi
 * @version $Id: $Id
 */
public class LogKit {

    private static class Holder {
        private static Log log = Log.getLog(LogKit.class);
    }


    /**
     * <p>saveLog.</p>
     */
    public static void  saveLog(){
        Model log= LogModel.me;

    }

    /**
     * 当通过 Constants.setLogFactory(...) 或者
     * LogManager.me().setDefaultLogFacotyr(...)
     * 指定默认日志工厂以后，重置一下内部 Log 对象，以便使内部日志实现与系统保持一致
     */
    public static void synchronizeLog() {
        Holder.log = Log.getLog(LogKit.class);
    }

    /**
     * Do nothing.
     *
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void logNothing(Throwable t) {

    }

    /**
     * <p>debug.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public static void debug(String message) {
        Holder.log.debug(message);
    }

    /**
     * <p>debug.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void debug(String message, Throwable t) {
        Holder.log.debug(message, t);
    }

    /**
     * <p>info.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public static void info(String message) {
        Holder.log.info(message);
    }

    /**
     * <p>info.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void info(String message, Throwable t) {
        Holder.log.info(message, t);
    }

    /**
     * <p>warn.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public static void warn(String message) {
        Holder.log.warn(message);
    }

    /**
     * <p>warn.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void warn(String message, Throwable t) {
        Holder.log.warn(message, t);
    }

    /**
     * <p>error.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public static void error(String message) {
        Holder.log.error(message);
    }

    /**
     * <p>error.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void error(String message, Throwable t) {
        Holder.log.error(message, t);
    }

    /**
     * <p>fatal.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public static void fatal(String message) {
        Holder.log.fatal(message);
    }

    /**
     * <p>fatal.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public static void fatal(String message, Throwable t) {
        Holder.log.fatal(message, t);
    }

    /**
     * <p>isDebugEnabled.</p>
     *
     * @return a boolean.
     */
    public static boolean isDebugEnabled() {
        return Holder.log.isDebugEnabled();
    }

    /**
     * <p>isInfoEnabled.</p>
     *
     * @return a boolean.
     */
    public static boolean isInfoEnabled() {
        return Holder.log.isInfoEnabled();
    }

    /**
     * <p>isWarnEnabled.</p>
     *
     * @return a boolean.
     */
    public static boolean isWarnEnabled() {
        return Holder.log.isWarnEnabled();
    }

    /**
     * <p>isErrorEnabled.</p>
     *
     * @return a boolean.
     */
    public static boolean isErrorEnabled() {
        return Holder.log.isErrorEnabled();
    }

    /**
     * <p>isFatalEnabled.</p>
     *
     * @return a boolean.
     */
    public static boolean isFatalEnabled() {
        return Holder.log.isFatalEnabled();
    }



}

