package space.yizhu.kits;/* Created by xiuxi on 2018/10/10.*/

/**
 * <p>NumberKit class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class NumberKit {

    /**
     * <p>getInt.</p>
     *
     * @param str a {@link java.lang.String} object.
     * @return a int.
     */
    public static int getInt(String str) {
        if (str == null)
            return 0;
        if (str.contains(".")) {
            str = str.substring(0, str.indexOf("."));
        }
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    /**
     * <p>getInt.</p>
     *
     * @param obj a {@link java.lang.Object} object.
     * @return a int.
     */
    public static int getInt(Object obj) {
        if (obj == null)
            return 0;
        String str = String.valueOf(obj);
        if (str.contains(".")) {
            str = str.substring(0, str.indexOf("."));
        }
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {
            return 0;
        }
    }


    /**
     * <p>decimalToHex.</p>
     *
     * @param decimal a int.
     * @return a {@link java.lang.String} object.
     */
    public static String decimalToHex(int decimal) {
        String hex = "";
        while (decimal != 0) {
            int hexValue = decimal % 16;
            hex = toHexChar(hexValue) + hex;
            decimal = decimal / 16;
        }
        return hex;
    }

    //将0~15的十进制数转换成0~F的十六进制数
    /**
     * <p>toHexChar.</p>
     *
     * @param hexValue a int.
     * @return a char.
     */
    public static char toHexChar(int hexValue) {
        if (hexValue <= 9 && hexValue >= 0)
            return (char) (hexValue + '0');
        else
            return (char) (hexValue - 10 + 'A');
    }
}
