package space.yizhu.record.aop;


/**
 * <p>Aop class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Aop {

    private static AopFactory aopFactory = new AopFactory();

    /**
     * <p>get.</p>
     *
     * @param targetClass a {@link java.lang.Class} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T get(Class<T> targetClass) {
        return aopFactory.get(targetClass);
    }

    /**
     * <p>get.</p>
     *
     * @param targetClass a {@link java.lang.Class} object.
     * @param injectDepth a int.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T get(Class<T> targetClass, int injectDepth) {
        return aopFactory.get(targetClass, injectDepth);
    }

    /**
     * <p>inject.</p>
     *
     * @param targetObject a T object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T inject(T targetObject) {
        return aopFactory.inject(targetObject);
    }

    /**
     * <p>inject.</p>
     *
     * @param targetObject a T object.
     * @param injectDepth a int.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T inject(T targetObject, int injectDepth) {
        return aopFactory.inject(targetObject, injectDepth);
    }

    
    /**
     * <p>addSingletonObject.</p>
     *
     * @param singletonObject a {@link java.lang.Object} object.
     */
    public static void addSingletonObject(Object singletonObject) {
        aopFactory.addSingletonObject(singletonObject);
    }

    
    /**
     * <p>addMapping.</p>
     *
     * @param from a {@link java.lang.Class} object.
     * @param to a {@link java.lang.Class} object.
     * @param <T> a T object.
     */
    public static <T> void addMapping(Class<T> from, Class<? extends T> to) {
        aopFactory.addMapping(from, to);
    }

    
    /**
     * <p>addMapping.</p>
     *
     * @param from a {@link java.lang.Class} object.
     * @param to a {@link java.lang.String} object.
     * @param <T> a T object.
     */
    public static <T> void addMapping(Class<T> from, String to) {
        aopFactory.addMapping(from, to);
    }
	
	

    
    /**
     * <p>Setter for the field <code>aopFactory</code>.</p>
     *
     * @param aopFactory a {@link space.yizhu.record.aop.AopFactory} object.
     */
    public static void setAopFactory(AopFactory aopFactory) {
        if (aopFactory == null) {
            throw new IllegalArgumentException("aopFactory can not be null");
        }
        Aop.aopFactory = aopFactory;
    }

    /**
     * <p>Getter for the field <code>aopFactory</code>.</p>
     *
     * @return a {@link space.yizhu.record.aop.AopFactory} object.
     */
    public static AopFactory getAopFactory() {
        return aopFactory;
    }

    
    /**
     * <p>setEnhance.</p>
     *
     * @param enhance a boolean.
     */
    @Deprecated
    public static void setEnhance(boolean enhance) {
        aopFactory.setEnhance(enhance);
    }

    
    /**
     * <p>setSingleton.</p>
     *
     * @param singleton a boolean.
     */
    public static void setSingleton(boolean singleton) {
        aopFactory.setSingleton(singleton);
    }

    /**
     * <p>isSingleton.</p>
     *
     * @return a boolean.
     */
    public static boolean isSingleton() {
        return aopFactory.isSingleton();
    }

    
    /**
     * <p>setInjectDepth.</p>
     *
     * @param injectDepth a int.
     */
    public static void setInjectDepth(int injectDepth) {
        aopFactory.setInjectDepth(injectDepth);
    }

    /**
     * <p>getInjectDepth.</p>
     *
     * @return a int.
     */
    public static int getInjectDepth() {
        return aopFactory.getInjectDepth();
    }
}




