

package space.yizhu.record.log;


/**
 * <p>Abstract Log class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public abstract class Log {

    private static ILogFactory defaultLogFactory = null;

    static {
        init();
    }

    static void init() {
        if (defaultLogFactory == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                Class<?> log4jLogFactoryClass = Class.forName("space.yizhu.record.log.Log4jLogFactory");
                defaultLogFactory = (ILogFactory) log4jLogFactoryClass.newInstance();    
            } catch (Exception e) {
            }
        }
    }

    static void setDefaultLogFactory(ILogFactory defaultLogFactory) {
        if (defaultLogFactory == null) {
            throw new IllegalArgumentException("defaultLogFactory can not be null.");
        }
        Log.defaultLogFactory = defaultLogFactory;
    }

    /**
     * <p>getLog.</p>
     *
     * @param clazz a {@link java.lang.Class} object.
     * @return a {@link space.yizhu.record.log.Log} object.
     */
    public static Log getLog(Class<?> clazz) {
        return defaultLogFactory.getLog(clazz);
    }

    /**
     * <p>getLog.</p>
     *
     * @param name a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.log.Log} object.
     */
    public static Log getLog(String name) {
        return defaultLogFactory.getLog(name);
    }

    /**
     * <p>debug.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public abstract void debug(String message);

    /**
     * <p>debug.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public abstract void debug(String message, Throwable t);

    /**
     * <p>info.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public abstract void info(String message);

    /**
     * <p>info.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public abstract void info(String message, Throwable t);

    /**
     * <p>warn.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public abstract void warn(String message);

    /**
     * <p>warn.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public abstract void warn(String message, Throwable t);

    /**
     * <p>error.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public abstract void error(String message);

    /**
     * <p>error.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public abstract void error(String message, Throwable t);

    /**
     * <p>fatal.</p>
     *
     * @param message a {@link java.lang.String} object.
     */
    public abstract void fatal(String message);

    /**
     * <p>fatal.</p>
     *
     * @param message a {@link java.lang.String} object.
     * @param t a {@link java.lang.Throwable} object.
     */
    public abstract void fatal(String message, Throwable t);

    /**
     * <p>isDebugEnabled.</p>
     *
     * @return a boolean.
     */
    public abstract boolean isDebugEnabled();

    /**
     * <p>isInfoEnabled.</p>
     *
     * @return a boolean.
     */
    public abstract boolean isInfoEnabled();

    /**
     * <p>isWarnEnabled.</p>
     *
     * @return a boolean.
     */
    public abstract boolean isWarnEnabled();

    /**
     * <p>isErrorEnabled.</p>
     *
     * @return a boolean.
     */
    public abstract boolean isErrorEnabled();

    /**
     * <p>isFatalEnabled.</p>
     *
     * @return a boolean.
     */
    public abstract boolean isFatalEnabled();
}

