

package space.yizhu.record.plugin.activerecord;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * <p>Abstract CPI class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public abstract class CPI {

    
    /**
     * <p>getAttrs.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link java.util.Map} object.
     */
    public static final Map<String, Object> getAttrs(Model model) {
        return model._getAttrs();
    }

    /**
     * <p>getModifyFlag.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link java.util.Set} object.
     */
    public static final Set<String> getModifyFlag(Model model) {
        return model._getModifyFlag();
    }

    /**
     * <p>getTable.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Table} object.
     */
    public static final Table getTable(Model model) {
        return model._getTable();
    }

    /**
     * <p>getConfig.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static final Config getConfig(Model model) {
        return model._getConfig();
    }

    /**
     * <p>getUsefulClass.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link java.lang.Class} object.
     */
    public static final Class<? extends Model> getUsefulClass(Model model) {
        return model._getUsefulClass();
    }

    /**
     * <p>query.</p>
     *
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a {@link java.util.List} object.
     * @throws java.sql.SQLException if any.
     */
    public static <T> List<T> query(Connection conn, String sql, Object... paras) throws SQLException {
        return Db.query(DbConfig.config, conn, sql, paras);
    }

    /**
     * <p>query.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a {@link java.util.List} object.
     * @throws java.sql.SQLException if any.
     */
    public static <T> List<T> query(String configName, Connection conn, String sql, Object... paras) throws SQLException {
        return Db.query(DbConfig.getConfig(configName), conn, sql, paras);
    }

    

    /**
     * <p>setColumnsMap.</p>
     *
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @param columns a {@link java.util.Map} object.
     */
    public static void setColumnsMap(Record record, Map<String, Object> columns) {
        record.setColumnsMap(columns);
    }

    /**
     * <p>find.</p>
     *
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.util.List} object.
     * @throws java.sql.SQLException if any.
     */
    public static List<Record> find(Connection conn, String sql, Object... paras) throws SQLException {
        return Db.find(DbConfig.config, conn, sql, paras);
    }

    /**
     * <p>find.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.util.List} object.
     * @throws java.sql.SQLException if any.
     */
    public static List<Record> find(String configName, Connection conn, String sql, Object... paras) throws SQLException {
        return Db.find(DbConfig.getConfig(configName), conn, sql, paras);
    }

    /**
     * <p>paginate.</p>
     *
     * @param conn a {@link java.sql.Connection} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     * @throws java.sql.SQLException if any.
     */
    public static Page<Record> paginate(Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object... paras) throws SQLException {
        return Db.paginate(DbConfig.config, conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    /**
     * <p>paginate.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @param conn a {@link java.sql.Connection} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     * @throws java.sql.SQLException if any.
     */
    public static Page<Record> paginate(String configName, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object... paras) throws SQLException {
        return Db.paginate(DbConfig.getConfig(configName), conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    /**
     * <p>update.</p>
     *
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a int.
     * @throws java.sql.SQLException if any.
     */
    public static int update(Connection conn, String sql, Object... paras) throws SQLException {
        return Db.update(DbConfig.config, conn, sql, paras);
    }

    /**
     * <p>update.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @param conn a {@link java.sql.Connection} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a int.
     * @throws java.sql.SQLException if any.
     */
    public static int update(String configName, Connection conn, String sql, Object... paras) throws SQLException {
        return Db.update(DbConfig.getConfig(configName), conn, sql, paras);
    }

    /**
     * <p>setTablePrimaryKey.</p>
     *
     * @param table a {@link space.yizhu.record.plugin.activerecord.Table} object.
     * @param primaryKey a {@link java.lang.String} object.
     */
    public static void setTablePrimaryKey(Table table, String primaryKey) {
        table.setPrimaryKey(primaryKey);
    }
}

