

package space.yizhu.record.plugin.activerecord;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import space.yizhu.kits.SyncWriteMap;


/**
 * <p>Db class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings("rawtypes")
public class Db {

    private static DbPro MAIN = null;
    private static final Map<String, DbPro> map = new SyncWriteMap<String, DbPro>(32, 0.25F);

    
    static void init(String configName) {
        MAIN = DbConfig.getConfig(configName).dbProFactory.getDbPro(configName);
        map.put(configName, MAIN);
    }

    
    static void removeDbProWithConfig(String configName) {
        if (MAIN != null && MAIN.config.getName().equals(configName)) {
            MAIN = null;
        }
        map.remove(configName);
    }

    /**
     * <p>use.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.DbPro} object.
     */
    public static DbPro use(String configName) {
        DbPro result = map.get(configName);
        if (result == null) {
            Config config = DbConfig.getConfig(configName);
            if (config == null) {
                throw new IllegalArgumentException("Config not found by configName: " + configName);
            }
            result = config.dbProFactory.getDbPro(configName);    
            map.put(configName, result);
        }
        return result;
    }

    /**
     * <p>use.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.DbPro} object.
     */
    public static DbPro use() {
        return MAIN;
    }

    static <T> List<T> query(Config config, Connection conn, String sql, Object... paras) throws SQLException {
        return MAIN.query(config, conn, sql, paras);
    }

    
    /**
     * <p>query.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a {@link java.util.List} object.
     */
    public static <T> List<T> query(String sql, Object... paras) {
        return MAIN.query(sql, paras);
    }

    
    /**
     * <p>query.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param <T> a T object.
     * @return a {@link java.util.List} object.
     */
    public static <T> List<T> query(String sql) {
        return MAIN.query(sql);
    }

    
    /**
     * <p>queryFirst.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T queryFirst(String sql, Object... paras) {
        return MAIN.queryFirst(sql, paras);
    }

    
    /**
     * <p>queryFirst.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T queryFirst(String sql) {
        return MAIN.queryFirst(sql);
    }

    

    
    /**
     * <p>queryColumn.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T queryColumn(String sql, Object... paras) {
        return MAIN.queryColumn(sql, paras);
    }

    /**
     * <p>queryColumn.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param <T> a T object.
     * @return a T object.
     */
    public static <T> T queryColumn(String sql) {
        return MAIN.queryColumn(sql);
    }

    /**
     * <p>queryStr.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.String} object.
     */
    public static String queryStr(String sql, Object... paras) {
        return MAIN.queryStr(sql, paras);
    }

    /**
     * <p>queryStr.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String queryStr(String sql) {
        return MAIN.queryStr(sql);
    }

    /**
     * <p>queryInt.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Integer} object.
     */
    public static Integer queryInt(String sql, Object... paras) {
        return MAIN.queryInt(sql, paras);
    }

    /**
     * <p>queryInt.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Integer} object.
     */
    public static Integer queryInt(String sql) {
        return MAIN.queryInt(sql);
    }

    /**
     * <p>queryLong.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Long} object.
     */
    public static Long queryLong(String sql, Object... paras) {
        return MAIN.queryLong(sql, paras);
    }

    /**
     * <p>queryLong.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Long} object.
     */
    public static Long queryLong(String sql) {
        return MAIN.queryLong(sql);
    }

    /**
     * <p>queryDouble.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Double} object.
     */
    public static Double queryDouble(String sql, Object... paras) {
        return MAIN.queryDouble(sql, paras);
    }

    /**
     * <p>queryDouble.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Double} object.
     */
    public static Double queryDouble(String sql) {
        return MAIN.queryDouble(sql);
    }

    /**
     * <p>queryFloat.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Float} object.
     */
    public static Float queryFloat(String sql, Object... paras) {
        return MAIN.queryFloat(sql, paras);
    }

    /**
     * <p>queryFloat.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Float} object.
     */
    public static Float queryFloat(String sql) {
        return MAIN.queryFloat(sql);
    }

    /**
     * <p>queryBigDecimal.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.math.BigDecimal} object.
     */
    public static java.math.BigDecimal queryBigDecimal(String sql, Object... paras) {
        return MAIN.queryBigDecimal(sql, paras);
    }

    /**
     * <p>queryBigDecimal.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.math.BigDecimal} object.
     */
    public static java.math.BigDecimal queryBigDecimal(String sql) {
        return MAIN.queryBigDecimal(sql);
    }

    /**
     * <p>queryBytes.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return an array of {@link byte} objects.
     */
    public static byte[] queryBytes(String sql, Object... paras) {
        return MAIN.queryBytes(sql, paras);
    }

    /**
     * <p>queryBytes.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return an array of {@link byte} objects.
     */
    public static byte[] queryBytes(String sql) {
        return MAIN.queryBytes(sql);
    }

    /**
     * <p>queryDate.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.util.Date} object.
     */
    public static java.util.Date queryDate(String sql, Object... paras) {
        return MAIN.queryDate(sql, paras);
    }

    /**
     * <p>queryDate.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.util.Date} object.
     */
    public static java.util.Date queryDate(String sql) {
        return MAIN.queryDate(sql);
    }

    /**
     * <p>queryTime.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.sql.Time} object.
     */
    public static java.sql.Time queryTime(String sql, Object... paras) {
        return MAIN.queryTime(sql, paras);
    }

    /**
     * <p>queryTime.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.sql.Time} object.
     */
    public static java.sql.Time queryTime(String sql) {
        return MAIN.queryTime(sql);
    }

    /**
     * <p>queryTimestamp.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.sql.Timestamp} object.
     */
    public static java.sql.Timestamp queryTimestamp(String sql, Object... paras) {
        return MAIN.queryTimestamp(sql, paras);
    }

    /**
     * <p>queryTimestamp.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.sql.Timestamp} object.
     */
    public static java.sql.Timestamp queryTimestamp(String sql) {
        return MAIN.queryTimestamp(sql);
    }

    /**
     * <p>queryBoolean.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public static Boolean queryBoolean(String sql, Object... paras) {
        return MAIN.queryBoolean(sql, paras);
    }

    /**
     * <p>queryBoolean.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public static Boolean queryBoolean(String sql) {
        return MAIN.queryBoolean(sql);
    }

    /**
     * <p>queryShort.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Short} object.
     */
    public static Short queryShort(String sql, Object... paras) {
        return MAIN.queryShort(sql, paras);
    }

    /**
     * <p>queryShort.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Short} object.
     */
    public static Short queryShort(String sql) {
        return MAIN.queryShort(sql);
    }

    /**
     * <p>queryByte.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Byte} object.
     */
    public static Byte queryByte(String sql, Object... paras) {
        return MAIN.queryByte(sql, paras);
    }

    /**
     * <p>queryByte.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Byte} object.
     */
    public static Byte queryByte(String sql) {
        return MAIN.queryByte(sql);
    }

    /**
     * <p>queryNumber.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.lang.Number} object.
     */
    public static Number queryNumber(String sql, Object... paras) {
        return MAIN.queryNumber(sql, paras);
    }

    /**
     * <p>queryNumber.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.lang.Number} object.
     */
    public static Number queryNumber(String sql) {
        return MAIN.queryNumber(sql);
    }
    

    
    static int update(Config config, Connection conn, String sql, Object... paras) throws SQLException {
        return MAIN.update(config, conn, sql, paras);
    }

    
    /**
     * <p>update.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a int.
     */
    public static int update(String sql, Object... paras) {
        return MAIN.update(sql, paras);
    }

    
    /**
     * <p>update.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a int.
     */
    public static int update(String sql) {
        return MAIN.update(sql);
    }

    static List<Record> find(Config config, Connection conn, String sql, Object... paras) throws SQLException {
        return MAIN.find(config, conn, sql, paras);
    }

    
    /**
     * <p>find.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> find(String sql, Object... paras) {
        return MAIN.find(sql, paras);
    }

    
    /**
     * <p>find.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> find(String sql) {
        return MAIN.find(sql);
    }

    /**
     * <p>findAll.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> findAll(String tableName) {
        return MAIN.findAll(tableName);
    }

    
    /**
     * <p>findFirst.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findFirst(String sql, Object... paras) {
        return MAIN.findFirst(sql, paras);
    }

    
    /**
     * <p>findFirst.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findFirst(String sql) {
        return MAIN.findFirst(sql);
    }

    
    /**
     * <p>findById.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param idValue a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findById(String tableName, Object idValue) {
        return MAIN.findById(tableName, idValue);
    }

    /**
     * <p>findById.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param idValue a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findById(String tableName, String primaryKey, Object idValue) {
        return MAIN.findById(tableName, primaryKey, idValue);
    }

    
    /**
     * <p>findByIds.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param idValues a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findByIds(String tableName, String primaryKey, Object... idValues) {
        return MAIN.findByIds(tableName, primaryKey, idValues);
    }

    
    /**
     * <p>deleteById.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param idValue a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public static boolean deleteById(String tableName, Object idValue) {
        return MAIN.deleteById(tableName, idValue);
    }

    /**
     * <p>deleteById.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param idValue a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public static boolean deleteById(String tableName, String primaryKey, Object idValue) {
        return MAIN.deleteById(tableName, primaryKey, idValue);
    }

    
    /**
     * <p>deleteByIds.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param idValues a {@link java.lang.Object} object.
     * @return a boolean.
     */
    public static boolean deleteByIds(String tableName, String primaryKey, Object... idValues) {
        return MAIN.deleteByIds(tableName, primaryKey, idValues);
    }

    
    /**
     * <p>delete.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean delete(String tableName, String primaryKey, Record record) {
        return MAIN.delete(tableName, primaryKey, record);
    }

    
    /**
     * <p>delete.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean delete(String tableName, Record record) {
        return MAIN.delete(tableName, record);
    }

    
    /**
     * <p>delete.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a int.
     */
    public static int delete(String sql, Object... paras) {
        return MAIN.delete(sql, paras);
    }

    
    /**
     * <p>delete.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a int.
     */
    public static int delete(String sql) {
        return MAIN.delete(sql);
    }

    static Page<Record> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object... paras) throws SQLException {
        return MAIN.paginate(config, conn, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    
    /**
     * <p>paginate.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object... paras) {
        return MAIN.paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    /**
     * <p>paginate.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param isGroupBySql a boolean.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object... paras) {
        return MAIN.paginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    
    /**
     * <p>paginate.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return MAIN.paginate(pageNumber, pageSize, select, sqlExceptSelect);
    }

    /**
     * <p>paginateByFullSql.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param totalRowSql a {@link java.lang.String} object.
     * @param findSql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object... paras) {
        return MAIN.paginateByFullSql(pageNumber, pageSize, totalRowSql, findSql, paras);
    }

    /**
     * <p>paginateByFullSql.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param isGroupBySql a boolean.
     * @param totalRowSql a {@link java.lang.String} object.
     * @param findSql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object... paras) {
        return MAIN.paginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    static boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        return MAIN.save(config, conn, tableName, primaryKey, record);
    }

    
    /**
     * <p>save.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean save(String tableName, String primaryKey, Record record) {
        return MAIN.save(tableName, primaryKey, record);
    }

    
    /**
     * <p>save.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean save(String tableName, Record record) {
        return MAIN.save(tableName, record);
    }

    static boolean update(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        return MAIN.update(config, conn, tableName, primaryKey, record);
    }

    
    /**
     * <p>update.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean update(String tableName, String primaryKey, Record record) {
        return MAIN.update(tableName, primaryKey, record);
    }

    
    /**
     * <p>update.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a boolean.
     */
    public static boolean update(String tableName, Record record) {
        return MAIN.update(tableName, record);
    }

    
    /**
     * <p>execute.</p>
     *
     * @param callback a {@link space.yizhu.record.plugin.activerecord.ICallback} object.
     * @return a {@link java.lang.Object} object.
     */
    public static Object execute(ICallback callback) {
        return MAIN.execute(callback);
    }

    
    static Object execute(Config config, ICallback callback) {
        return MAIN.execute(config, callback);
    }

    
    static boolean tx(Config config, int transactionLevel, IAtom atom) {
        return MAIN.tx(config, transactionLevel, atom);
    }

    /**
     * <p>tx.</p>
     *
     * @param transactionLevel a int.
     * @param atom a {@link space.yizhu.record.plugin.activerecord.IAtom} object.
     * @return a boolean.
     */
    public static boolean tx(int transactionLevel, IAtom atom) {
        return MAIN.tx(transactionLevel, atom);
    }

    
    /**
     * <p>tx.</p>
     *
     * @param atom a {@link space.yizhu.record.plugin.activerecord.IAtom} object.
     * @return a boolean.
     */
    public static boolean tx(IAtom atom) {
        return MAIN.tx(atom);
    }

    
    /**
     * <p>findByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> findByCache(String cacheName, Object key, String sql, Object... paras) {
        return MAIN.findByCache(cacheName, key, sql, paras);
    }

    
    /**
     * <p>findByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param sql a {@link java.lang.String} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> findByCache(String cacheName, Object key, String sql) {
        return MAIN.findByCache(cacheName, key, sql);
    }

    
    /**
     * <p>findFirstByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param sql a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findFirstByCache(String cacheName, Object key, String sql, Object... paras) {
        return MAIN.findFirstByCache(cacheName, key, sql, paras);
    }

    
    /**
     * <p>findFirstByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param sql a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findFirstByCache(String cacheName, Object key, String sql) {
        return MAIN.findFirstByCache(cacheName, key, sql);
    }

    
    /**
     * <p>paginateByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object... paras) {
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    /**
     * <p>paginateByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param isGroupBySql a boolean.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object... paras) {
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    
    /**
     * <p>paginateByCache.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param select a {@link java.lang.String} object.
     * @param sqlExceptSelect a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return MAIN.paginateByCache(cacheName, key, pageNumber, pageSize, select, sqlExceptSelect);
    }

    
    /**
     * <p>batch.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param paras an array of {@link java.lang.Object} objects.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batch(String sql, Object[][] paras, int batchSize) {
        return MAIN.batch(sql, paras, batchSize);
    }

    
    /**
     * <p>batch.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @param columns a {@link java.lang.String} object.
     * @param modelOrRecordList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        return MAIN.batch(sql, columns, modelOrRecordList, batchSize);
    }

    
    /**
     * <p>batch.</p>
     *
     * @param sqlList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batch(List<String> sqlList, int batchSize) {
        return MAIN.batch(sqlList, batchSize);
    }

    
    /**
     * <p>batchSave.</p>
     *
     * @param modelList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batchSave(List<? extends Model> modelList, int batchSize) {
        return MAIN.batchSave(modelList, batchSize);
    }

    
    /**
     * <p>batchSave.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param recordList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batchSave(String tableName, List<Record> recordList, int batchSize) {
        return MAIN.batchSave(tableName, recordList, batchSize);
    }

    
    /**
     * <p>batchUpdate.</p>
     *
     * @param modelList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batchUpdate(List<? extends Model> modelList, int batchSize) {
        return MAIN.batchUpdate(modelList, batchSize);
    }

    
    /**
     * <p>batchUpdate.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param recordList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batchUpdate(String tableName, String primaryKey, List<Record> recordList, int batchSize) {
        return MAIN.batchUpdate(tableName, primaryKey, recordList, batchSize);
    }

    
    /**
     * <p>batchUpdate.</p>
     *
     * @param tableName a {@link java.lang.String} object.
     * @param recordList a {@link java.util.List} object.
     * @param batchSize a int.
     * @return an array of {@link int} objects.
     */
    public static int[] batchUpdate(String tableName, List<Record> recordList, int batchSize) {
        return MAIN.batchUpdate(tableName, recordList, batchSize);
    }

    /**
     * <p>getSql.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String getSql(String key) {
        return MAIN.getSql(key);
    }

    /**
     * <p>getSqlPara.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlPara(String key, Record record) {
        return MAIN.getSqlPara(key, record);
    }

    /**
     * <p>getSqlPara.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlPara(String key, Model model) {
        return MAIN.getSqlPara(key, model);
    }

    /**
     * <p>getSqlPara.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param data a {@link java.util.Map} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlPara(String key, Map data) {
        return MAIN.getSqlPara(key, data);
    }

    /**
     * <p>getSqlPara.</p>
     *
     * @param key a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlPara(String key, Object... paras) {
        return MAIN.getSqlPara(key, paras);
    }

    /**
     * <p>getSqlParaByString.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param data a {@link java.util.Map} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlParaByString(String content, Map data) {
        return MAIN.getSqlParaByString(content, data);
    }

    /**
     * <p>getSqlParaByString.</p>
     *
     * @param content a {@link java.lang.String} object.
     * @param paras a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public static SqlPara getSqlParaByString(String content, Object... paras) {
        return MAIN.getSqlParaByString(content, paras);
    }

    /**
     * <p>find.</p>
     *
     * @param sqlPara a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     * @return a {@link java.util.List} object.
     */
    public static List<Record> find(SqlPara sqlPara) {
        return MAIN.find(sqlPara);
    }

    /**
     * <p>findFirst.</p>
     *
     * @param sqlPara a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public static Record findFirst(SqlPara sqlPara) {
        return MAIN.findFirst(sqlPara);
    }

    /**
     * <p>update.</p>
     *
     * @param sqlPara a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     * @return a int.
     */
    public static int update(SqlPara sqlPara) {
        return MAIN.update(sqlPara);
    }

    /**
     * <p>paginate.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param sqlPara a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        return MAIN.paginate(pageNumber, pageSize, sqlPara);
    }

    /**
     * <p>paginate.</p>
     *
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param isGroupBySql a boolean.
     * @param sqlPara a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Page} object.
     */
    public static Page<Record> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        return MAIN.paginate(pageNumber, pageSize, isGroupBySql, sqlPara);
    }
}



