

package space.yizhu.record.plugin.activerecord;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;


/**
 * <p>DbConfig class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings("rawtypes")
public final class DbConfig {


    static Config config = null;


    static Config brokenConfig = Config.createBrokenConfig();

    private static Map<Class<? extends Model>, Config> modelToConfig = new HashMap<Class<? extends Model>, Config>(512, 0.5F);
    private static Map<String, Config> configNameToConfig = new HashMap<String, Config>(32, 0.25F);

    static final Object[] NULL_PARA_ARRAY = new Object[0];
    /** Constant <code>MAIN_CONFIG_NAME="main"</code> */
    public static final String MAIN_CONFIG_NAME = "main";
    /** Constant <code>DEFAULT_TRANSACTION_LEVEL=Connection.TRANSACTION_REPEATABLE_READ</code> */
    public static final int DEFAULT_TRANSACTION_LEVEL = Connection.TRANSACTION_REPEATABLE_READ;

    private DbConfig() {
    }


    /**
     * <p>addConfig.</p>
     *
     * @param config a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static void addConfig(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        if (configNameToConfig.containsKey(config.getName())) {
            throw new IllegalArgumentException("Config already exists: " + config.getName());
        }

        configNameToConfig.put(config.getName(), config);


        if (MAIN_CONFIG_NAME.equals(config.getName())) {
            DbConfig.config = config;
            Db.init(DbConfig.config.getName());
        }


        if (DbConfig.config == null) {
            DbConfig.config = config;
            Db.init(DbConfig.config.getName());
        }
    }

    /**
     * <p>removeConfig.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static Config removeConfig(String configName) {
        if (DbConfig.config != null && DbConfig.config.getName().equals(configName)) {

            DbConfig.config = null;
        }

        Db.removeDbProWithConfig(configName);
        return configNameToConfig.remove(configName);
    }

    static void addModelToConfigMapping(Class<? extends Model> modelClass, Config config) {
        modelToConfig.put(modelClass, config);
    }

    /**
     * <p>Getter for the field <code>config</code>.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static Config getConfig() {
        return config;
    }

    /**
     * <p>Getter for the field <code>config</code>.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static Config getConfig(String configName) {
        return configNameToConfig.get(configName);
    }

    /**
     * <p>Getter for the field <code>config</code>.</p>
     *
     * @param modelClass a {@link java.lang.Class} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Config} object.
     */
    public static Config getConfig(Class<? extends Model> modelClass) {
        return modelToConfig.get(modelClass);
    }

    static final void close(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        if (st != null) {
            try {
                st.close();
            } catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    static final void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            } catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    /**
     * <p>getConfigSet.</p>
     *
     * @return a {@link java.util.Set} object.
     */
    public static Set<Map.Entry<String, Config>> getConfigSet() {
        return configNameToConfig.entrySet();
    }

    /**
     * <p>getUsefulClass.</p>
     *
     * @param modelClass a {@link java.lang.Class} object.
     * @return a {@link java.lang.Class} object.
     */
    @SuppressWarnings("unchecked")
    public static Class<? extends Model> getUsefulClass(Class<? extends Model> modelClass) {


        return (Class<? extends Model>) (modelClass.getName().indexOf("$$EnhancerBy") == -1 ? modelClass : modelClass.getSuperclass());
    }
}




