

package space.yizhu.record.plugin.activerecord;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * <p>IContainerFactory interface.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@SuppressWarnings("rawtypes")
public interface IContainerFactory {
    /**
     * <p>getAttrsMap.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    Map getAttrsMap();

    /**
     * <p>getColumnsMap.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    Map getColumnsMap();

    /**
     * <p>getModifyFlagSet.</p>
     *
     * @return a {@link java.util.Set} object.
     */
    Set getModifyFlagSet();

    /** Constant <code>defaultContainerFactory</code> */
    static final IContainerFactory defaultContainerFactory = new IContainerFactory() {

        public Map<String, Object> getAttrsMap() {
            return new HashMap<String, Object>();
        }

        public Map<String, Object> getColumnsMap() {
            return new HashMap<String, Object>();
        }

        public Set<String> getModifyFlagSet() {
            return new HashSet<String>();
        }
    };
}
