

package space.yizhu.record.plugin.activerecord;


/**
 * <p>IDbProFactory interface.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public interface IDbProFactory {

    /**
     * <p>getDbPro.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.DbPro} object.
     */
    DbPro getDbPro(String configName);

    /** Constant <code>defaultDbProFactory</code> */
    static final IDbProFactory defaultDbProFactory = new IDbProFactory() {
        public DbPro getDbPro(String configName) {
            return new DbPro(configName);
        }
    };
}


