

package space.yizhu.record.plugin.activerecord;

import java.io.Serializable;
import java.util.List;


/**
 * <p>Page class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Page<T> implements Serializable {

    private static final long serialVersionUID = -7102129155309986923L;

    private List<T> list;                
    private int pageNumber;                
    private int pageSize;                
    private int totalPage;                
    private int totalRow;                

    
    /**
     * <p>Constructor for Page.</p>
     *
     * @param list a {@link java.util.List} object.
     * @param pageNumber a int.
     * @param pageSize a int.
     * @param totalPage a int.
     * @param totalRow a int.
     */
    public Page(List<T> list, int pageNumber, int pageSize, int totalPage, int totalRow) {
        this.list = list;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalPage = totalPage;
        this.totalRow = totalRow;
    }

    /**
     * <p>Constructor for Page.</p>
     */
    public Page() {

    }

    
    /**
     * <p>Getter for the field <code>list</code>.</p>
     *
     * @return a {@link java.util.List} object.
     */
    public List<T> getList() {
        return list;
    }

    /**
     * <p>Setter for the field <code>list</code>.</p>
     *
     * @param list a {@link java.util.List} object.
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    
    /**
     * <p>Getter for the field <code>pageNumber</code>.</p>
     *
     * @return a int.
     */
    public int getPageNumber() {
        return pageNumber;
    }

    /**
     * <p>Setter for the field <code>pageNumber</code>.</p>
     *
     * @param pageNumber a int.
     */
    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    
    /**
     * <p>Getter for the field <code>pageSize</code>.</p>
     *
     * @return a int.
     */
    public int getPageSize() {
        return pageSize;
    }

    /**
     * <p>Setter for the field <code>pageSize</code>.</p>
     *
     * @param pageSize a int.
     */
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    
    /**
     * <p>Getter for the field <code>totalPage</code>.</p>
     *
     * @return a int.
     */
    public int getTotalPage() {
        return totalPage;
    }

    /**
     * <p>Setter for the field <code>totalPage</code>.</p>
     *
     * @param totalPage a int.
     */
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    
    /**
     * <p>Getter for the field <code>totalRow</code>.</p>
     *
     * @return a int.
     */
    public int getTotalRow() {
        return totalRow;
    }

    /**
     * <p>Setter for the field <code>totalRow</code>.</p>
     *
     * @param totalRow a int.
     */
    public void setTotalRow(int totalRow) {
        this.totalRow = totalRow;
    }

    /**
     * <p>isFirstPage.</p>
     *
     * @return a boolean.
     */
    public boolean isFirstPage() {
        return pageNumber == 1;
    }

    /**
     * <p>isLastPage.</p>
     *
     * @return a boolean.
     */
    public boolean isLastPage() {
        return pageNumber >= totalPage;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("pageNumber : ").append(pageNumber);
        msg.append("\npageSize : ").append(pageSize);
        msg.append("\ntotalPage : ").append(totalPage);
        msg.append("\ntotalRow : ").append(totalRow);
        return msg.toString();
    }
}

