

package space.yizhu.record.plugin.activerecord;

import com.google.gson.Gson;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;


/**
 * <p>Record class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Record implements Serializable {

    private static final long serialVersionUID = 905784513600884082L;

    private Map<String, Object> columns;    

    
    /**
     * <p>setContainerFactoryByConfigName.</p>
     *
     * @param configName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record setContainerFactoryByConfigName(String configName) {
        Config config = DbConfig.getConfig(configName);
        if (config == null)
            throw new IllegalArgumentException("Config not found: " + configName);

        processColumnsMap(config);
        return this;
    }

    
    void setColumnsMap(Map<String, Object> columns) {
        this.columns = columns;
    }

    @SuppressWarnings("unchecked")
    private void processColumnsMap(Config config) {
        if (columns == null || columns.size() == 0) {
            columns = config.containerFactory.getColumnsMap();
        } else {
            Map<String, Object> columnsOld = columns;
            columns = config.containerFactory.getColumnsMap();
            columns.putAll(columnsOld);
        }
    }

    
    /**
     * <p>Getter for the field <code>columns</code>.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    @SuppressWarnings("unchecked")
    public Map<String, Object> getColumns() {
        if (columns == null) {
            if (DbConfig.config == null)
                columns = DbConfig.brokenConfig.containerFactory.getColumnsMap();
            else
                columns = DbConfig.config.containerFactory.getColumnsMap();
        }
        return columns;
    }

    
    /**
     * <p>Setter for the field <code>columns</code>.</p>
     *
     * @param columns a {@link java.util.Map} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record setColumns(Map<String, Object> columns) {
        this.getColumns().putAll(columns);
        return this;
    }

    
    /**
     * <p>Setter for the field <code>columns</code>.</p>
     *
     * @param record a {@link space.yizhu.record.plugin.activerecord.Record} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record setColumns(Record record) {
        getColumns().putAll(record.getColumns());
        return this;
    }

    
    /**
     * <p>Setter for the field <code>columns</code>.</p>
     *
     * @param model a {@link space.yizhu.record.plugin.activerecord.Model} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record setColumns(Model<?> model) {
        getColumns().putAll(model._getAttrs());
        return this;
    }

    
    /**
     * <p>remove.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record remove(String column) {
        getColumns().remove(column);
        return this;
    }

    
    /**
     * <p>remove.</p>
     *
     * @param columns a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record remove(String... columns) {
        if (columns != null)
            for (String c : columns)
                this.getColumns().remove(c);
        return this;
    }

    
    /**
     * <p>removeNullValueColumns.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record removeNullValueColumns() {
        for (java.util.Iterator<Entry<String, Object>> it = getColumns().entrySet().iterator(); it.hasNext(); ) {
            Entry<String, Object> e = it.next();
            if (e.getValue() == null) {
                it.remove();
            }
        }
        return this;
    }

    
    /**
     * <p>keep.</p>
     *
     * @param columns a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record keep(String... columns) {
        if (columns != null && columns.length > 0) {
            Map<String, Object> newColumns = new HashMap<String, Object>(columns.length);    
            for (String c : columns)
                if (this.getColumns().containsKey(c))    
                    newColumns.put(c, this.getColumns().get(c));

            this.getColumns().clear();
            this.getColumns().putAll(newColumns);
        } else
            this.getColumns().clear();
        return this;
    }

    
    /**
     * <p>keep.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record keep(String column) {
        if (getColumns().containsKey(column)) {    
            Object keepIt = getColumns().get(column);
            getColumns().clear();
            getColumns().put(column, keepIt);
        } else
            getColumns().clear();
        return this;
    }

    
    /**
     * <p>clear.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record clear() {
        getColumns().clear();
        return this;
    }

    
    /**
     * <p>set.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @param value a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Record} object.
     */
    public Record set(String column, Object value) {
        getColumns().put(column, value);
        return this;
    }

    
    /**
     * <p>get.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @param <T> a T object.
     * @return a T object.
     */
    @SuppressWarnings("unchecked")
    public <T> T get(String column) {
        return (T) getColumns().get(column);
    }

    
    /**
     * <p>get.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a T object.
     */
    @SuppressWarnings("unchecked")
    public <T> T get(String column, Object defaultValue) {
        Object result = getColumns().get(column);
        return (T) (result != null ? result : defaultValue);
    }

    /**
     * <p>getObject.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Object} object.
     */
    public Object getObject(String column) {
        return getColumns().get(column);
    }

    /**
     * <p>getObject.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @param defaultValue a {@link java.lang.Object} object.
     * @return a {@link java.lang.Object} object.
     */
    public Object getObject(String column, Object defaultValue) {
        Object result = getColumns().get(column);
        return result != null ? result : defaultValue;
    }

    
    /**
     * <p>getStr.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public String getStr(String column) {
        
        Object s = getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    
    /**
     * <p>getInt.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getInt(String column) {
        Number n = getNumber(column);
        return n != null ? n.intValue() : null;
    }

    
    /**
     * <p>getLong.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Long} object.
     */
    public Long getLong(String column) {
        Number n = getNumber(column);
        return n != null ? n.longValue() : null;
    }

    
    /**
     * <p>getBigInteger.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.math.BigInteger} object.
     */
    public java.math.BigInteger getBigInteger(String column) {
        return (java.math.BigInteger) getColumns().get(column);
    }

    
    /**
     * <p>getDate.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.util.Date} object.
     */
    public java.util.Date getDate(String column) {
        return (java.util.Date) getColumns().get(column);
    }

    
    /**
     * <p>getTime.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.sql.Time} object.
     */
    public java.sql.Time getTime(String column) {
        return (java.sql.Time) getColumns().get(column);
    }

    
    /**
     * <p>getTimestamp.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.sql.Timestamp} object.
     */
    public java.sql.Timestamp getTimestamp(String column) {
        return (java.sql.Timestamp) getColumns().get(column);
    }

    
    /**
     * <p>getDouble.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Double} object.
     */
    public Double getDouble(String column) {
        Number n = getNumber(column);
        return n != null ? n.doubleValue() : null;
    }

    
    /**
     * <p>getFloat.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Float} object.
     */
    public Float getFloat(String column) {
        Number n = getNumber(column);
        return n != null ? n.floatValue() : null;
    }

    /**
     * <p>getShort.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Short} object.
     */
    public Short getShort(String column) {
        Number n = getNumber(column);
        return n != null ? n.shortValue() : null;
    }

    /**
     * <p>getByte.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Byte} object.
     */
    public Byte getByte(String column) {
        Number n = getNumber(column);
        return n != null ? n.byteValue() : null;
    }

    
    /**
     * <p>getBoolean.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Boolean} object.
     */
    public Boolean getBoolean(String column) {
        return (Boolean) getColumns().get(column);
    }

    
    /**
     * <p>getBigDecimal.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.math.BigDecimal} object.
     */
    public java.math.BigDecimal getBigDecimal(String column) {
        return (java.math.BigDecimal) getColumns().get(column);
    }

    
    /**
     * <p>getBytes.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return an array of {@link byte} objects.
     */
    public byte[] getBytes(String column) {
        return (byte[]) getColumns().get(column);
    }

    
    /**
     * <p>getNumber.</p>
     *
     * @param column a {@link java.lang.String} object.
     * @return a {@link java.lang.Number} object.
     */
    public Number getNumber(String column) {
        return (Number) getColumns().get(column);
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        if (columns == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Entry<String, Object> e : getColumns().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    /** {@inheritDoc} */
    public boolean equals(Object o) {
        if (!(o instanceof Record))
            return false;
        if (o == this)
            return true;
        return getColumns().equals(((Record) o).getColumns());
    }

    /**
     * <p>hashCode.</p>
     *
     * @return a int.
     */
    public int hashCode() {
        return getColumns().hashCode();
    }

    
    /**
     * <p>getColumnNames.</p>
     *
     * @return an array of {@link java.lang.String} objects.
     */
    public String[] getColumnNames() {
        Set<String> attrNameSet = getColumns().keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    
    /**
     * <p>getColumnValues.</p>
     *
     * @return an array of {@link java.lang.Object} objects.
     */
    public Object[] getColumnValues() {
        java.util.Collection<Object> attrValueCollection = getColumns().values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    
    /**
     * <p>toJson.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toJson() {
        return new Gson().toJson(getColumns());
    }
}




