

package space.yizhu.record.plugin.activerecord;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * <p>SqlPara class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class SqlPara implements Serializable {

    private static final long serialVersionUID = -8586448059592782381L;

    String sql;
    List<Object> paraList;

    /**
     * <p>Setter for the field <code>sql</code>.</p>
     *
     * @param sql a {@link java.lang.String} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public SqlPara setSql(String sql) {
        this.sql = sql;
        return this;
    }

    /**
     * <p>addPara.</p>
     *
     * @param para a {@link java.lang.Object} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public SqlPara addPara(Object para) {
        if (paraList == null) {
            paraList = new ArrayList<Object>();
        }
        paraList.add(para);
        return this;
    }

    /**
     * <p>Getter for the field <code>sql</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getSql() {
        return sql;
    }

    /**
     * <p>getPara.</p>
     *
     * @return an array of {@link java.lang.Object} objects.
     */
    public Object[] getPara() {
        if (paraList == null || paraList.size() == 0) {
            return DbConfig.NULL_PARA_ARRAY;
        } else {
            return paraList.toArray(new Object[paraList.size()]);
        }
    }

    /**
     * <p>clear.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.SqlPara} object.
     */
    public SqlPara clear() {
        sql = null;
        if (paraList != null) {
            paraList.clear();
        }
        return this;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return "Sql: " + sql + "\nPara: " + paraList;
    }
}
