

package space.yizhu.record.plugin.activerecord;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;


/**
 * <p>SqlReporter class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class SqlReporter implements InvocationHandler {

    private Connection conn;
    private static boolean logOn = false;

    SqlReporter(Connection conn) {
        this.conn = conn;
    }

    /**
     * <p>setLog.</p>
     *
     * @param on a boolean.
     */
    public static void setLog(boolean on) {
        SqlReporter.logOn = on;
    }

    @SuppressWarnings("rawtypes")
    Connection getConnection() {
        Class clazz = conn.getClass();
        return (Connection) Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{Connection.class}, this);
    }

    /**
     * <p>invoke.</p>
     *
     * @param proxy a {@link java.lang.Object} object.
     * @param method a {@link java.lang.reflect.Method} object.
     * @param args an array of {@link java.lang.Object} objects.
     * @return a {@link java.lang.Object} object.
     * @throws java.lang.Throwable if any.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("prepareStatement")) {
                String info = "Sql: " + args[0];

                System.out.println(info);
            }
            return method.invoke(conn, args);
        } catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}




