

package space.yizhu.record.plugin.activerecord;

import java.util.concurrent.ConcurrentHashMap;

import space.yizhu.record.core.Const;
import space.yizhu.kits.ConfigFile;


/**
 * <p>Sqls class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
@Deprecated
public class Sqls {

    private static ConfigFile configFile = null;
    private static final ConcurrentHashMap<String, ConfigFile> map = new ConcurrentHashMap<String, ConfigFile>();

    private Sqls() {
    }

    
    /**
     * <p>load.</p>
     *
     * @param sqlFileName a {@link java.lang.String} object.
     */
    public static void load(String sqlFileName) {
        use(sqlFileName);
    }

    /**
     * <p>get.</p>
     *
     * @param sqlKey a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String get(String sqlKey) {
        if (configFile == null)
            throw new IllegalStateException("Init sql propties file by invoking Sqls.load(String fileName) method first.");
        return configFile.get(sqlKey);
    }

    /**
     * <p>get.</p>
     *
     * @param slqFileName a {@link java.lang.String} object.
     * @param sqlKey a {@link java.lang.String} object.
     * @return a {@link java.lang.String} object.
     */
    public static String get(String slqFileName, String sqlKey) {
        ConfigFile configFile = map.get(slqFileName);
        if (configFile == null)
            throw new IllegalStateException("Init sql propties file by invoking Sqls.load(String fileName) method first.");
        return configFile.get(sqlKey);
    }

    private static ConfigFile use(String fileName) {
        return use(fileName, Const.DEFAULT_ENCODING);
    }

    private static ConfigFile use(String fileName, String encoding) {
        ConfigFile result = map.get(fileName);
        if (result == null) {
            result = new ConfigFile(fileName, encoding);
            map.put(fileName, result);
            if (Sqls.configFile == null)
                Sqls.configFile = result;
        }
        return result;
    }

    /**
     * <p>useless.</p>
     *
     * @param sqlFileName a {@link java.lang.String} object.
     * @return a {@link space.yizhu.kits.ConfigFile} object.
     */
    public static ConfigFile useless(String sqlFileName) {
        ConfigFile previous = map.remove(sqlFileName);
        if (Sqls.configFile == previous)
            Sqls.configFile = null;
        return previous;
    }

    /**
     * <p>clear.</p>
     */
    public static void clear() {
        configFile = null;
        map.clear();
    }
}



