

package space.yizhu.record.plugin.activerecord;

import java.util.Collections;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import space.yizhu.kits.StrKit;


/**
 * <p>Table class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Table {

    private String name;
    private String[] primaryKey = null;
    private Map<String, Class<?>> columnTypeMap;    

    private Class<? extends Model<?>> modelClass;

    /**
     * <p>Constructor for Table.</p>
     *
     * @param name a {@link java.lang.String} object.
     * @param modelClass a {@link java.lang.Class} object.
     */
    public Table(String name, Class<? extends Model<?>> modelClass) {
        if (StrKit.isBlank(name))
            throw new IllegalArgumentException("Table name can not be blank.");
        if (modelClass == null)
            throw new IllegalArgumentException("Model class can not be null.");

        this.name = name.trim();
        this.modelClass = modelClass;
    }

    /**
     * <p>Constructor for Table.</p>
     *
     * @param name a {@link java.lang.String} object.
     * @param primaryKey a {@link java.lang.String} object.
     * @param modelClass a {@link java.lang.Class} object.
     */
    public Table(String name, String primaryKey, Class<? extends Model<?>> modelClass) {
        if (StrKit.isBlank(name))
            throw new IllegalArgumentException("Table name can not be blank.");
        if (StrKit.isBlank(primaryKey))
            throw new IllegalArgumentException("Primary key can not be blank.");
        if (modelClass == null)
            throw new IllegalArgumentException("Model class can not be null.");

        this.name = name.trim();
        setPrimaryKey(primaryKey.trim());
        this.modelClass = modelClass;
    }

    void setPrimaryKey(String primaryKey) {
        String[] arr = primaryKey.split(",");
        for (int i = 0; i < arr.length; i++)
            arr[i] = arr[i].trim();
        this.primaryKey = arr;
    }

    void setColumnTypeMap(Map<String, Class<?>> columnTypeMap) {
        if (columnTypeMap == null)
            throw new IllegalArgumentException("columnTypeMap can not be null");

        this.columnTypeMap = columnTypeMap;
    }

    /**
     * <p>Getter for the field <code>name</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getName() {
        return name;
    }

    void setColumnType(String columnLabel, Class<?> columnType) {
        columnTypeMap.put(columnLabel, columnType);
    }

    /**
     * <p>getColumnType.</p>
     *
     * @param columnLabel a {@link java.lang.String} object.
     * @return a {@link java.lang.Class} object.
     */
    public Class<?> getColumnType(String columnLabel) {
        return columnTypeMap.get(columnLabel);
    }

    
    /**
     * <p>hasColumnLabel.</p>
     *
     * @param columnLabel a {@link java.lang.String} object.
     * @return a boolean.
     */
    public boolean hasColumnLabel(String columnLabel) {
        return columnTypeMap.containsKey(columnLabel);
    }

    
    /**
     * <p>Getter for the field <code>primaryKey</code>.</p>
     *
     * @return an array of {@link java.lang.String} objects.
     */
    public String[] getPrimaryKey() {
        return primaryKey;
    }

    /**
     * <p>Getter for the field <code>modelClass</code>.</p>
     *
     * @return a {@link java.lang.Class} object.
     */
    public Class<? extends Model<?>> getModelClass() {
        return modelClass;
    }

    /**
     * <p>Getter for the field <code>columnTypeMap</code>.</p>
     *
     * @return a {@link java.util.Map} object.
     */
    public Map<String, Class<?>> getColumnTypeMap() {
        return Collections.unmodifiableMap(columnTypeMap);
    }

    /**
     * <p>getColumnTypeMapEntrySet.</p>
     *
     * @return a {@link java.util.Set} object.
     */
    public Set<Entry<String, Class<?>>> getColumnTypeMapEntrySet() {
        return Collections.unmodifiableSet(columnTypeMap.entrySet());
    }

    /**
     * <p>getColumnNameSet.</p>
     *
     * @return a {@link java.util.Set} object.
     */
    public Set<String> getColumnNameSet() {
        return Collections.unmodifiableSet(columnTypeMap.keySet());
    }
}





