

package space.yizhu.record.plugin.activerecord;

import java.util.HashMap;
import java.util.Map;


/**
 * <p>TableMapping class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class TableMapping {

    private final Map<Class<? extends Model<?>>, Table> modelToTableMap = new HashMap<Class<? extends Model<?>>, Table>(512, 0.5F);

    private static TableMapping me = new TableMapping();

    private TableMapping() {
    }

    /**
     * <p>me.</p>
     *
     * @return a {@link space.yizhu.record.plugin.activerecord.TableMapping} object.
     */
    public static TableMapping me() {
        return me;
    }

    /**
     * <p>putTable.</p>
     *
     * @param table a {@link space.yizhu.record.plugin.activerecord.Table} object.
     */
    public void putTable(Table table) {
        modelToTableMap.put(table.getModelClass(), table);
    }

    /**
     * <p>getTable.</p>
     *
     * @param modelClass a {@link java.lang.Class} object.
     * @return a {@link space.yizhu.record.plugin.activerecord.Table} object.
     */
    @SuppressWarnings("rawtypes")
    public Table getTable(Class<? extends Model> modelClass) {
        return modelToTableMap.get(modelClass);
    }
}


