

package space.yizhu.record.plugin.activerecord.builder;

import java.sql.ResultSet;
import java.sql.SQLException;


/**
 * <p>BuilderKit class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class BuilderKit {

    /**
     * <p>getByte.</p>
     *
     * @param rs a {@link java.sql.ResultSet} object.
     * @param i a int.
     * @return a {@link java.lang.Byte} object.
     * @throws java.sql.SQLException if any.
     */
    public static Byte getByte(ResultSet rs, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (value != null) {
            value = Byte.parseByte(value + "");
            return (Byte) value;
        } else {
            return null;
        }
    }

    /**
     * <p>getShort.</p>
     *
     * @param rs a {@link java.sql.ResultSet} object.
     * @param i a int.
     * @return a {@link java.lang.Short} object.
     * @throws java.sql.SQLException if any.
     */
    public static Short getShort(ResultSet rs, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (value != null) {
            value = Short.parseShort(value + "");
            return (Short) value;
        } else {
            return null;
        }
    }
}

