

package space.yizhu.record.plugin.activerecord.builder;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import space.yizhu.record.plugin.activerecord.CPI;
import space.yizhu.record.plugin.activerecord.Config;
import space.yizhu.record.plugin.activerecord.ModelBuilder;
import space.yizhu.record.plugin.activerecord.Record;
import space.yizhu.record.plugin.activerecord.RecordBuilder;


/**
 * <p>KeepByteAndShortRecordBuilder class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class KeepByteAndShortRecordBuilder extends RecordBuilder {

    /** Constant <code>me</code> */
    public static final KeepByteAndShortRecordBuilder me = new KeepByteAndShortRecordBuilder();

    /** {@inheritDoc} */
    @SuppressWarnings("unchecked")
    public List<Record> build(Config config, ResultSet rs) throws SQLException {
        List<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Record record = new Record();
            CPI.setColumnsMap(record, config.getContainerFactory().getColumnsMap());
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; i++) {
                Object value;
                int t = types[i];
                if (t < Types.DATE) {
                    if (t == Types.TINYINT) {
                        value = BuilderKit.getByte(rs, i);
                    } else if (t == Types.SMALLINT) {
                        value = BuilderKit.getShort(rs, i);
                    } else {
                        value = rs.getObject(i);
                    }
                } else {
                    if (t == Types.TIMESTAMP) {
                        value = rs.getTimestamp(i);
                    } else if (t == Types.DATE) {
                        value = rs.getDate(i);
                    } else if (t == Types.CLOB) {
                        value = ModelBuilder.me.handleClob(rs.getClob(i));
                    } else if (t == Types.NCLOB) {
                        value = ModelBuilder.me.handleClob(rs.getNClob(i));
                    } else if (t == Types.BLOB) {
                        value = ModelBuilder.me.handleBlob(rs.getBlob(i));
                    } else {
                        value = rs.getObject(i);
                    }
                }

                columns.put(labelNames[i], value);
            }
            result.add(record);
        }
        return result;
    }
}



