

package space.yizhu.record.plugin.activerecord.cache;


/**
 * <p>ICache interface.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public interface ICache {
    /**
     * <p>get.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param <T> a T object.
     * @return a T object.
     */
    <T> T get(String cacheName, Object key);

    /**
     * <p>put.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     * @param value a {@link java.lang.Object} object.
     */
    void put(String cacheName, Object key, Object value);

    /**
     * <p>remove.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     * @param key a {@link java.lang.Object} object.
     */
    void remove(String cacheName, Object key);

    /**
     * <p>removeAll.</p>
     *
     * @param cacheName a {@link java.lang.String} object.
     */
    void removeAll(String cacheName);
}
