

package space.yizhu.record.plugin.activerecord.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

import space.yizhu.kits.Kv;
import space.yizhu.kits.LogKit;
import space.yizhu.kits.StrKit;
import space.yizhu.record.template.Engine;


/**
 * <p>MappingKitGenerator class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class MappingKitGenerator {

    protected Engine engine;
    protected String template = "/space/yizhu/record/plugin/activerecord/generator/mapping_kit_template.jf";

    protected String mappingKitPackageName;
    protected String mappingKitOutputDir;
    protected String mappingKitClassName = "_MappingKit";

    /**
     * <p>Constructor for MappingKitGenerator.</p>
     *
     * @param mappingKitPackageName a {@link java.lang.String} object.
     * @param mappingKitOutputDir a {@link java.lang.String} object.
     */
    public MappingKitGenerator(String mappingKitPackageName, String mappingKitOutputDir) {
        this.mappingKitPackageName = mappingKitPackageName;
        this.mappingKitOutputDir = mappingKitOutputDir;

        initEngine();
    }

    /**
     * <p>initEngine.</p>
     */
    protected void initEngine() {
        engine = new Engine();
        engine.setToClassPathSourceFactory();
        engine.addSharedMethod(new StrKit());
    }

    
    /**
     * <p>Setter for the field <code>template</code>.</p>
     *
     * @param template a {@link java.lang.String} object.
     */
    public void setTemplate(String template) {
        this.template = template;
    }

    /**
     * <p>Setter for the field <code>mappingKitOutputDir</code>.</p>
     *
     * @param mappingKitOutputDir a {@link java.lang.String} object.
     */
    public void setMappingKitOutputDir(String mappingKitOutputDir) {
        if (StrKit.notBlank(mappingKitOutputDir)) {
            this.mappingKitOutputDir = mappingKitOutputDir;
        }
    }

    /**
     * <p>Getter for the field <code>mappingKitOutputDir</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getMappingKitOutputDir() {
        return mappingKitOutputDir;
    }

    /**
     * <p>Setter for the field <code>mappingKitPackageName</code>.</p>
     *
     * @param mappingKitPackageName a {@link java.lang.String} object.
     */
    public void setMappingKitPackageName(String mappingKitPackageName) {
        if (StrKit.notBlank(mappingKitPackageName)) {
            this.mappingKitPackageName = mappingKitPackageName;
        }
    }

    /**
     * <p>Getter for the field <code>mappingKitPackageName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getMappingKitPackageName() {
        return mappingKitPackageName;
    }

    /**
     * <p>Setter for the field <code>mappingKitClassName</code>.</p>
     *
     * @param mappingKitClassName a {@link java.lang.String} object.
     */
    public void setMappingKitClassName(String mappingKitClassName) {
        if (StrKit.notBlank(mappingKitClassName)) {
            this.mappingKitClassName = StrKit.firstCharToUpperCase(mappingKitClassName);
        }
    }

    /**
     * <p>Getter for the field <code>mappingKitClassName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getMappingKitClassName() {
        return mappingKitClassName;
    }

    /**
     * <p>generate.</p>
     *
     * @param tableMetas a {@link java.util.List} object.
     */
    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate MappingKit file ...");
        System.out.println("MappingKit Output Dir: " + mappingKitOutputDir);

        Kv data = Kv.by("mappingKitPackageName", mappingKitPackageName);
        data.set("mappingKitClassName", mappingKitClassName);
        data.set("tableMetas", tableMetas);

        String ret = engine.getTemplate(template).renderToString(data);
        writeToFile(ret);
    }

    
    /**
     * <p>writeToFile.</p>
     *
     * @param ret a {@link java.lang.String} object.
     */
    protected void writeToFile(String ret) {
        File dir = new File(mappingKitOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        String target = mappingKitOutputDir + File.separator + mappingKitClassName + ".java";
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(target), "UTF-8");
            osw.write(ret);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if (osw != null) {
                try {
                    osw.close();
                } catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }
}




