

package space.yizhu.record.plugin.activerecord.sql;

import java.util.Map;

import space.yizhu.kits.StrKit;
import space.yizhu.record.template.Directive;
import space.yizhu.record.template.Env;
import space.yizhu.record.template.Template;
import space.yizhu.record.template.expr.ast.Const;
import space.yizhu.record.template.expr.ast.Expr;
import space.yizhu.record.template.expr.ast.ExprList;
import space.yizhu.record.template.io.Writer;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>SqlDirective class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class SqlDirective extends Directive {

    private String id;

    /** {@inheritDoc} */
    public void setExprList(ExprList exprList) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #sql directive can not be blank", location);
        }
        if (exprList.length() > 1) {
            throw new ParseException("Only one parameter allowed for #sql directive", location);
        }
        Expr expr = exprList.getExpr(0);
        if (expr instanceof Const && ((Const) expr).isStr()) {
        } else {
            throw new ParseException("The parameter of #sql directive must be String", location);
        }

        this.id = ((Const) expr).getStr();
    }

    /** {@inheritDoc} */
    @SuppressWarnings("unchecked")
    public void exec(Env env, Scope scope, Writer writer) {
        String nameSpace = (String) scope.get(NameSpaceDirective.NAME_SPACE_KEY);
        String key = StrKit.isBlank(nameSpace) ? id : nameSpace + "." + id;
        Map<String, Template> sqlTemplateMap = (Map<String, Template>) scope.get(SqlKit.SQL_TEMPLATE_MAP_KEY);
        if (sqlTemplateMap.containsKey(key)) {
            throw new ParseException("Sql already exists with key : " + key, location);
        }

        sqlTemplateMap.put(key, new Template(env, stat));
    }

    /**
     * <p>hasEnd.</p>
     *
     * @return a boolean.
     */
    public boolean hasEnd() {
        return true;
    }
}



