

package space.yizhu.record.template.expr;


/**
 * <p>Sym class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public enum Sym {

    ASSIGN("="),

    DOT("."), RANGE(".."), COLON(":"), STATIC("::"), COMMA(","), SEMICOLON(";"),
    LPAREN("("), RPAREN(")"), LBRACK("["), RBRACK("]"), LBRACE("{"), RBRACE("}"),

    ADD("+"), SUB("-"), INC("++"), DEC("--"),
    MUL("*"), DIV("/"), MOD("%"),

    EQUAL("=="), NOTEQUAL("!="), LT("<"), LE("<="), GT(">"), GE(">="),

    NOT("!"), AND("&&"), OR("||"),

    QUESTION("?"),
    NULL_SAFE("??"),

    ID("ID"),

    STR("STR"), TRUE("TRUE"), FALSE("FALSE"), NULL("NULL"),
    INT("INT"), LONG("LONG"), FLOAT("FLOAT"), DOUBLE("DOUBLE"),

    EOF("EOF");

    private final String value;

    private Sym(String value) {
        this.value = value;
    }

    /**
     * <p>value.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String value() {
        return value;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return value;
    }
}





