

package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.expr.Sym;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>Const class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Const extends Expr {

    /** Constant <code>TRUE</code> */
    public static final Const TRUE = new Const(Sym.TRUE, Boolean.TRUE);
    /** Constant <code>FALSE</code> */
    public static final Const FALSE = new Const(Sym.FALSE, Boolean.FALSE);
    /** Constant <code>NULL</code> */
    public static final Const NULL = new Const(Sym.NULL, null);

    private final Sym type;
    private final Object value;

    
    /**
     * <p>Constructor for Const.</p>
     *
     * @param type a {@link space.yizhu.record.template.expr.Sym} object.
     * @param value a {@link java.lang.Object} object.
     */
    public Const(Sym type, Object value) {
        this.type = type;
        this.value = value;
    }

    /** {@inheritDoc} */
    public Object eval(Scope scope) {
        return value;
    }

    /**
     * <p>isStr.</p>
     *
     * @return a boolean.
     */
    public boolean isStr() {
        return type == Sym.STR;
    }

    /**
     * <p>isTrue.</p>
     *
     * @return a boolean.
     */
    public boolean isTrue() {
        return type == Sym.TRUE;
    }

    /**
     * <p>isFalse.</p>
     *
     * @return a boolean.
     */
    public boolean isFalse() {
        return type == Sym.FALSE;
    }

    /**
     * <p>isBoolean.</p>
     *
     * @return a boolean.
     */
    public boolean isBoolean() {
        return type == Sym.TRUE || type == Sym.FALSE;
    }

    /**
     * <p>isNull.</p>
     *
     * @return a boolean.
     */
    public boolean isNull() {
        return type == Sym.NULL;
    }

    /**
     * <p>isInt.</p>
     *
     * @return a boolean.
     */
    public boolean isInt() {
        return type == Sym.INT;
    }

    /**
     * <p>isLong.</p>
     *
     * @return a boolean.
     */
    public boolean isLong() {
        return type == Sym.LONG;
    }

    /**
     * <p>isFloat.</p>
     *
     * @return a boolean.
     */
    public boolean isFloat() {
        return type == Sym.FLOAT;
    }

    /**
     * <p>isDouble.</p>
     *
     * @return a boolean.
     */
    public boolean isDouble() {
        return type == Sym.DOUBLE;
    }

    /**
     * <p>isNumber.</p>
     *
     * @return a boolean.
     */
    public boolean isNumber() {
        return value instanceof Number;
    }

    /**
     * <p>Getter for the field <code>value</code>.</p>
     *
     * @return a {@link java.lang.Object} object.
     */
    public Object getValue() {
        return value;
    }

    /**
     * <p>getStr.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getStr() {
        return (String) value;
    }

    /**
     * <p>getBoolean.</p>
     *
     * @return a {@link java.lang.Boolean} object.
     */
    public Boolean getBoolean() {
        return (Boolean) value;
    }

    /**
     * <p>getInt.</p>
     *
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getInt() {
        return (Integer) value;
    }

    /**
     * <p>getLong.</p>
     *
     * @return a {@link java.lang.Long} object.
     */
    public Long getLong() {
        return (Long) value;
    }

    /**
     * <p>getFloat.</p>
     *
     * @return a {@link java.lang.Float} object.
     */
    public Float getFloat() {
        return (Float) value;
    }

    /**
     * <p>getDouble.</p>
     *
     * @return a {@link java.lang.Double} object.
     */
    public Double getDouble() {
        return (Double) value;
    }

    /**
     * <p>getNumber.</p>
     *
     * @return a {@link java.lang.Number} object.
     */
    public Number getNumber() {
        return (Number) value;
    }

    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return value != null ? value.toString() : "null";
    }
}








