

package space.yizhu.record.template.expr.ast;

import java.util.ArrayList;
import java.util.List;

import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>ExprList class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class ExprList extends Expr {

    /** Constant <code>NULL_EXPR</code> */
    public static final Expr NULL_EXPR = NullExpr.me;
    /** Constant <code>NULL_EXPR_ARRAY</code> */
    public static final Expr[] NULL_EXPR_ARRAY = new Expr[0];
    /** Constant <code>NULL_EXPR_LIST</code> */
    public static final ExprList NULL_EXPR_LIST = new ExprList(new ArrayList<Expr>(0));

    /** Constant <code>NULL_OBJECT_ARRAY</code> */
    public static final Object[] NULL_OBJECT_ARRAY = new Object[0];

    private Expr[] exprArray;

    /**
     * <p>Constructor for ExprList.</p>
     *
     * @param exprList a {@link java.util.List} object.
     */
    public ExprList(List<Expr> exprList) {
        if (exprList.size() > 0) {
            exprArray = exprList.toArray(new Expr[exprList.size()]);
        } else {
            exprArray = NULL_EXPR_ARRAY;
        }
    }

    
    /**
     * <p>getActualExpr.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getActualExpr() {
        if (exprArray.length == 1) {
            return exprArray[0];
        } else if (exprArray.length == 0) {
            return NULL_EXPR;
        } else {
            return this;
        }
    }

    /**
     * <p>Getter for the field <code>exprArray</code>.</p>
     *
     * @return an array of {@link space.yizhu.record.template.expr.ast.Expr} objects.
     */
    public Expr[] getExprArray() {
        return exprArray;
    }

    /**
     * <p>getExpr.</p>
     *
     * @param index a int.
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getExpr(int index) {
        if (index < 0 || index >= exprArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + exprArray.length, location);
        }
        return exprArray[index];
    }

    /**
     * <p>getFirstExpr.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getFirstExpr() {
        return exprArray.length > 0 ? exprArray[0] : null;
    }

    /**
     * <p>getLastExpr.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getLastExpr() {
        return exprArray.length > 0 ? exprArray[exprArray.length - 1] : null;
    }

    /**
     * <p>length.</p>
     *
     * @return a int.
     */
    public int length() {
        return exprArray.length;
    }

    
    /** {@inheritDoc} */
    public Object eval(Scope scope) {
        
        if (exprArray.length == 1) {
            return exprArray[0].eval(scope);
        }

        if (exprArray.length == 0) {
            return null;
        }

        int end = exprArray.length - 1;
        for (int i = 0; i < end; i++) {
            exprArray[i].eval(scope);
        }
        return exprArray[end].eval(scope);
    }

    
    /**
     * <p>evalExprList.</p>
     *
     * @param scope a {@link space.yizhu.record.template.stat.Scope} object.
     * @return an array of {@link java.lang.Object} objects.
     */
    public Object[] evalExprList(Scope scope) {
        if (exprArray.length == 0) {
            return NULL_OBJECT_ARRAY;
        }

        Object[] ret = new Object[exprArray.length];
        for (int i = 0; i < exprArray.length; i++) {
            ret[i] = exprArray[i].eval(scope);
        }
        return ret;
    }
}




