

package space.yizhu.record.template.expr.ast;


/**
 * <p>Abstract FieldKeyBuilder class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public abstract class FieldKeyBuilder {

    /**
     * <p>getFieldKey.</p>
     *
     * @param targetClass a {@link java.lang.Class} object.
     * @param fieldFnv1a64Hash a long.
     * @return a {@link java.lang.Object} object.
     */
    public abstract Object getFieldKey(Class<?> targetClass, long fieldFnv1a64Hash);

    
    static FieldKeyBuilder instance = new StrictFieldKeyBuilder();

    /**
     * <p>Getter for the field <code>instance</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.FieldKeyBuilder} object.
     */
    public static FieldKeyBuilder getInstance() {
        return instance;
    }

    
    /**
     * <p>setToFastFieldKeyBuilder.</p>
     */
    public static void setToFastFieldKeyBuilder() {
        instance = new FastFieldKeyBuilder();
    }

    
    /**
     * <p>setFieldKeyBuilder.</p>
     *
     * @param fieldKeyBuilder a {@link space.yizhu.record.template.expr.ast.FieldKeyBuilder} object.
     */
    public static void setFieldKeyBuilder(FieldKeyBuilder fieldKeyBuilder) {
        if (fieldKeyBuilder == null) {
            throw new IllegalArgumentException("fieldKeyBuilder can not be null");
        }
        instance = fieldKeyBuilder;
    }

    

    
    public static class FastFieldKeyBuilder extends FieldKeyBuilder {
        public Object getFieldKey(Class<?> targetClass, long fieldFnv1a64Hash) {
            return targetClass.getName().hashCode() ^ fieldFnv1a64Hash;
        }
    }

    

    
    public static class StrictFieldKeyBuilder extends FieldKeyBuilder {
        public Object getFieldKey(Class<?> targetClass, long fieldFnv1a64Hash) {
            return new FieldKey(targetClass.getName().hashCode(), fieldFnv1a64Hash);
        }
    }

    

    
    public static class FieldKey {

        final long classHash;
        final long fieldHash;

        public FieldKey(long classHash, long fieldHash) {
            this.classHash = classHash;
            this.fieldHash = fieldHash;
        }

        public int hashCode() {
            return (int) (classHash ^ fieldHash);
        }

        
        public boolean equals(Object fieldKey) {
            FieldKey fk = (FieldKey) fieldKey;
            return classHash == fk.classHash && fieldHash == fk.fieldHash;
        }

        public String toString() {
            return "classHash = " + classHash + "\nfieldHash = " + fieldHash;
        }
    }
}








