

package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.TemplateException;
import space.yizhu.record.template.stat.Location;
import space.yizhu.record.template.stat.ParseException;
import space.yizhu.record.template.stat.Scope;


/**
 * <p>ForCtrl class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class ForCtrl extends Expr {

    private String id;
    private Expr expr;

    private Expr init;
    private Expr cond;
    private Expr update;

    
    /**
     * <p>Constructor for ForCtrl.</p>
     *
     * @param id a {@link space.yizhu.record.template.expr.ast.Id} object.
     * @param expr a {@link space.yizhu.record.template.expr.ast.Expr} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public ForCtrl(Id id, Expr expr, Location location) {
        if (expr == null) {
            throw new ParseException("The iterator target of #for statement can not be null", location);
        }
        this.id = id.getId();
        this.expr = expr;
        this.init = null;
        this.cond = null;
        this.update = null;
        this.location = location;
    }

    
    /**
     * <p>Constructor for ForCtrl.</p>
     *
     * @param init a {@link space.yizhu.record.template.expr.ast.ExprList} object.
     * @param cond a {@link space.yizhu.record.template.expr.ast.Expr} object.
     * @param update a {@link space.yizhu.record.template.expr.ast.ExprList} object.
     * @param location a {@link space.yizhu.record.template.stat.Location} object.
     */
    public ForCtrl(ExprList init, Expr cond, ExprList update, Location location) {
        this.init = init.getActualExpr();
        this.cond = cond;
        this.update = update.getActualExpr();
        this.id = null;
        this.expr = null;
        this.location = location;
    }

    /**
     * <p>isIterator.</p>
     *
     * @return a boolean.
     */
    public boolean isIterator() {
        return id != null;
    }

    /**
     * <p>Getter for the field <code>id</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getId() {
        return id;
    }

    /**
     * <p>Getter for the field <code>expr</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getExpr() {
        return expr;
    }

    /**
     * <p>Getter for the field <code>init</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getInit() {
        return init;
    }

    /**
     * <p>Getter for the field <code>cond</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getCond() {
        return cond;
    }

    /**
     * <p>Getter for the field <code>update</code>.</p>
     *
     * @return a {@link space.yizhu.record.template.expr.ast.Expr} object.
     */
    public Expr getUpdate() {
        return update;
    }

    /** {@inheritDoc} */
    public Object eval(Scope scope) {
        throw new TemplateException("The eval(Scope scope) method can not be invoked", location);
    }
}


