

package space.yizhu.record.template.expr.ast;

import space.yizhu.record.template.stat.Scope;


/**
 * <p>Id class.</p>
 *
 * @author yi
 * @version $Id: $Id
 */
public class Id extends Expr {

    private final String id;

    /**
     * <p>Constructor for Id.</p>
     *
     * @param id a {@link java.lang.String} object.
     */
    public Id(String id) {
        this.id = id;
    }

    /**
     * <p>Getter for the field <code>id</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getId() {
        return id;
    }

    /** {@inheritDoc} */
    public Object eval(Scope scope) {
        return scope.get(id);
    }

    
    /**
     * <p>toString.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String toString() {
        return id;
    }
}


